/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.adobe;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.io.ReadStrategy;
import pixy.meta.MetadataEntry;
import pixy.meta.adobe.DataBlockType;
import pixy.string.StringUtils;

public class DDBEntry {
    private int type;
    private int size;
    protected byte[] data;
    protected ReadStrategy readStrategy;
    private static final Logger LOGGER = LoggerFactory.getLogger(DDBEntry.class);

    public DDBEntry(DataBlockType dataBlockType, int n, byte[] byArray, ReadStrategy readStrategy) {
        this(dataBlockType.getValue(), n, byArray, readStrategy);
    }

    public DDBEntry(int n, int n2, byte[] byArray, ReadStrategy readStrategy) {
        this.type = n;
        if (n2 < 0) {
            throw new IllegalArgumentException("Input size is negative");
        }
        this.size = n2;
        this.data = byArray;
        if (readStrategy == null) {
            throw new IllegalArgumentException("Input readStrategy is null");
        }
        this.readStrategy = readStrategy;
    }

    public void print() {
        DataBlockType dataBlockType = this.getTypeEnum();
        if (dataBlockType != DataBlockType.UNKNOWN) {
            LOGGER.info("Type: {} ({})", (Object)dataBlockType, (Object)dataBlockType.getDescription());
        } else {
            LOGGER.info("Type: Unknown (value 0x{})", (Object)Integer.toHexString(this.type));
        }
        LOGGER.info("Size: {}", (Object)this.size);
    }

    public int getType() {
        return this.type;
    }

    public DataBlockType getTypeEnum() {
        return DataBlockType.fromInt(this.type);
    }

    protected MetadataEntry getMetadataEntry() {
        DataBlockType dataBlockType = DataBlockType.fromInt(this.type);
        if (dataBlockType == DataBlockType.UNKNOWN) {
            return new MetadataEntry("UNKNOWN [" + StringUtils.intToHexStringMM(this.type) + "]:", dataBlockType.getDescription());
        }
        return new MetadataEntry("" + dataBlockType, dataBlockType.getDescription());
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }
}

