/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta.adobe;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.io.IOUtils;
import pixy.io.ReadStrategy;
import pixy.meta.Metadata;
import pixy.meta.MetadataEntry;
import pixy.meta.MetadataType;
import pixy.meta.adobe.DDBEntry;
import pixy.meta.adobe.DataBlockType;
import pixy.meta.adobe.FilterMask;
import pixy.meta.adobe.LayerData;
import pixy.meta.adobe.UserMask;
import pixy.util.ArrayUtils;

public class DDB
extends Metadata {
    private ReadStrategy readStrategy;
    private Map<Integer, DDBEntry> entries = new HashMap<Integer, DDBEntry>();
    public static final String DDB_ID = "Adobe Photoshop Document Data Block\u0000";
    public static final int _8BIM = 943868237;
    private static final Logger LOGGER = LoggerFactory.getLogger(DDB.class);

    public static void showDDB(byte[] byArray, ReadStrategy readStrategy) {
        if (byArray != null && byArray.length > 0) {
            DDB dDB = new DDB(byArray, readStrategy);
            try {
                dDB.read();
                dDB.showMetadata();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void showDDB(InputStream inputStream, ReadStrategy readStrategy) {
        try {
            DDB.showDDB(IOUtils.inputStreamToByteArray(inputStream), readStrategy);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public DDB(byte[] byArray, ReadStrategy readStrategy) {
        super(MetadataType.PHOTOSHOP_DDB, byArray);
        if (readStrategy == null) {
            throw new IllegalArgumentException("Input readStategy is null");
        }
        this.readStrategy = readStrategy;
    }

    public Map<Integer, DDBEntry> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> arrayList = new ArrayList<MetadataEntry>();
        for (DDBEntry dDBEntry : this.entries.values()) {
            arrayList.add(dDBEntry.getMetadataEntry());
        }
        return Collections.unmodifiableCollection(arrayList).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int n = 0;
            if (!new String(this.data, n, DDB_ID.length()).equals(DDB_ID)) {
                throw new RuntimeException("Invalid Photoshop Document Data Block");
            }
            n += DDB_ID.length();
            while (n + 4 < this.data.length) {
                int n2 = this.readStrategy.readInt(this.data, n);
                n += 4;
                if (n2 != 943868237) continue;
                int n3 = this.readStrategy.readInt(this.data, n);
                int n4 = this.readStrategy.readInt(this.data, n += 4);
                n += 4;
                DataBlockType dataBlockType = DataBlockType.fromInt(n3);
                switch (dataBlockType) {
                    case Layr: {
                        this.entries.put(n3, new LayerData(n4, ArrayUtils.subArray(this.data, n, n4), this.readStrategy));
                        break;
                    }
                    case LMsk: {
                        this.entries.put(n3, new UserMask(n4, ArrayUtils.subArray(this.data, n, n4), this.readStrategy));
                        break;
                    }
                    case FMsk: {
                        this.entries.put(n3, new FilterMask(n4, ArrayUtils.subArray(this.data, n, n4), this.readStrategy));
                        break;
                    }
                    default: {
                        this.entries.put(n3, new DDBEntry(n3, n4, ArrayUtils.subArray(this.data, n, n4), this.readStrategy));
                    }
                }
                n += n4 + 3 >> 2 << 2;
            }
            this.isDataRead = true;
        }
    }

    public void showMetadata() {
        this.ensureDataRead();
        LOGGER.info("<<Adobe DDB information starts>>");
        for (DDBEntry dDBEntry : this.entries.values()) {
            dDBEntry.print();
        }
        LOGGER.info("<<Adobe DDB information ends>>");
    }
}

