/*
 * Decompiled with CFR 0.152.
 */
package pixy.meta;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pixy.image.ImageType;
import pixy.io.FileCacheRandomAccessInputStream;
import pixy.io.FileCacheRandomAccessOutputStream;
import pixy.io.PeekHeadInputStream;
import pixy.io.RandomAccessInputStream;
import pixy.io.RandomAccessOutputStream;
import pixy.meta.MetadataEntry;
import pixy.meta.MetadataReader;
import pixy.meta.MetadataType;
import pixy.meta.adobe._8BIM;
import pixy.meta.bmp.BMPMeta;
import pixy.meta.exif.Exif;
import pixy.meta.gif.GIFMeta;
import pixy.meta.iptc.IPTCDataSet;
import pixy.meta.jpeg.JPGMeta;
import pixy.meta.png.PNGMeta;
import pixy.meta.tiff.TIFFMeta;
import pixy.meta.xmp.XMP;
import pixy.util.MetadataUtils;

public abstract class Metadata
implements MetadataReader,
Iterable<MetadataEntry> {
    public static final int IMAGE_MAGIC_NUMBER_LEN = 4;
    private MetadataType type;
    protected byte[] data;
    protected boolean isDataRead;
    private static final Logger LOGGER = LoggerFactory.getLogger(Metadata.class);

    public static void extractThumbnails(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Metadata.extractThumbnails(fileInputStream, string);
        fileInputStream.close();
    }

    public static void extractThumbnails(InputStream inputStream, String string) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = MetadataUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGMeta.extractThumbnails(peekHeadInputStream, string);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                TIFFMeta.extractThumbnail(fileCacheRandomAccessInputStream, string);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                break;
            }
            case PNG: {
                LOGGER.info("PNG image format does not contain any thumbnail");
                break;
            }
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not contain any thumbnails", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("Thumbnail extracting is not supported for " + imageType + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void extractThumbnails(String string, String string2) throws IOException {
        Metadata.extractThumbnails(new File(string), string2);
    }

    public static void insertComment(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        Metadata.insertComments(inputStream, outputStream, Arrays.asList(string));
    }

    public static void insertComments(InputStream inputStream, OutputStream outputStream, List<String> list) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = MetadataUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGMeta.insertComments(peekHeadInputStream, outputStream, list);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFMeta.insertComments(list, fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: {
                PNGMeta.insertComments(peekHeadInputStream, outputStream, list);
                break;
            }
            case GIF: {
                GIFMeta.insertComments(peekHeadInputStream, outputStream, list);
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support comment data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("comment data inserting is not supported for " + imageType + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertExif(InputStream inputStream, OutputStream outputStream, Exif exif) throws IOException {
        Metadata.insertExif(inputStream, outputStream, exif, false);
    }

    public static void insertExif(InputStream inputStream, OutputStream outputStream, Exif exif, boolean bl) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = MetadataUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGMeta.insertExif(peekHeadInputStream, outputStream, exif, bl);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFMeta.insertExif(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, exif, bl);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support EXIF data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("EXIF data inserting is not supported for " + imageType + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertICCProfile(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = MetadataUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGMeta.insertICCProfile((InputStream)peekHeadInputStream, outputStream, byArray);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFMeta.insertICCProfile(byArray, 0, fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support ICCProfile data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("ICCProfile data inserting is not supported for " + imageType + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertIPTC(InputStream inputStream, OutputStream outputStream, Collection<IPTCDataSet> collection) throws IOException {
        Metadata.insertIPTC(inputStream, outputStream, collection, false);
    }

    public static void insertIPTC(InputStream inputStream, OutputStream outputStream, Collection<IPTCDataSet> collection, boolean bl) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = MetadataUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGMeta.insertIPTC(peekHeadInputStream, outputStream, collection, bl);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFMeta.insertIPTC(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, collection, bl);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support IPTC data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("IPTC data inserting is not supported for " + imageType + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertIRB(InputStream inputStream, OutputStream outputStream, Collection<_8BIM> collection) throws IOException {
        Metadata.insertIRB(inputStream, outputStream, collection, false);
    }

    public static void insertIRB(InputStream inputStream, OutputStream outputStream, Collection<_8BIM> collection, boolean bl) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = MetadataUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGMeta.insertIRB(peekHeadInputStream, outputStream, collection, bl);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFMeta.insertIRB(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, collection, bl);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support IRB data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("IRB data inserting is not supported for " + imageType + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertIRBThumbnail(InputStream inputStream, OutputStream outputStream, BufferedImage bufferedImage) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = MetadataUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGMeta.insertIRBThumbnail(peekHeadInputStream, outputStream, bufferedImage);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFMeta.insertThumbnail(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, bufferedImage);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support IRB thumbnail", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("IRB thumbnail inserting is not supported for " + imageType + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertXMP(InputStream inputStream, OutputStream outputStream, XMP xMP) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = MetadataUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGMeta.insertXMP(peekHeadInputStream, outputStream, xMP);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFMeta.insertXMP(xMP, (RandomAccessInputStream)fileCacheRandomAccessInputStream, (RandomAccessOutputStream)fileCacheRandomAccessOutputStream);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: {
                PNGMeta.insertXMP((InputStream)peekHeadInputStream, outputStream, xMP);
                break;
            }
            case GIF: {
                GIFMeta.insertXMPApplicationBlock((InputStream)peekHeadInputStream, outputStream, xMP);
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support XMP data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("XMP inserting is not supported for " + imageType + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertXMP(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = MetadataUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPGMeta.insertXMP(peekHeadInputStream, outputStream, string, null);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFMeta.insertXMP(string, (RandomAccessInputStream)fileCacheRandomAccessInputStream, (RandomAccessOutputStream)fileCacheRandomAccessOutputStream);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: {
                PNGMeta.insertXMP((InputStream)peekHeadInputStream, outputStream, string);
                break;
            }
            case GIF: {
                GIFMeta.insertXMPApplicationBlock((InputStream)peekHeadInputStream, outputStream, string);
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support XMP data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("XMP inserting is not supported for " + imageType + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static Map<MetadataType, Metadata> readMetadata(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Map<MetadataType, Metadata> map = Metadata.readMetadata(fileInputStream);
        fileInputStream.close();
        return map;
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream inputStream) throws IOException {
        Map<Object, Object> map = new HashMap();
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = MetadataUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                map = JPGMeta.readMetadata(peekHeadInputStream);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                map = TIFFMeta.readMetadata(fileCacheRandomAccessInputStream);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                break;
            }
            case PNG: {
                map = PNGMeta.readMetadata(peekHeadInputStream);
                break;
            }
            case GIF: {
                map = GIFMeta.readMetadata(peekHeadInputStream);
                break;
            }
            case BMP: {
                map = BMPMeta.readMetadata(peekHeadInputStream);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("Metadata reading is not supported for " + imageType + " image");
            }
        }
        peekHeadInputStream.shallowClose();
        return map;
    }

    public static Map<MetadataType, Metadata> readMetadata(String string) throws IOException {
        return Metadata.readMetadata(new File(string));
    }

    public static Map<MetadataType, Metadata> removeMetadata(InputStream inputStream, OutputStream outputStream, MetadataType ... metadataTypeArray) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = MetadataUtils.guessImageType(peekHeadInputStream);
        Map<MetadataType, Metadata> map = Collections.emptyMap();
        switch (imageType) {
            case JPG: {
                map = JPGMeta.removeMetadata(peekHeadInputStream, outputStream, metadataTypeArray);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                map = TIFFMeta.removeMetadata(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, metadataTypeArray);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support meta data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("Metadata removing is not supported for " + imageType + " image");
            }
        }
        peekHeadInputStream.shallowClose();
        return map;
    }

    public Metadata(MetadataType metadataType) {
        this.type = metadataType;
    }

    public Metadata(MetadataType metadataType, byte[] byArray) {
        if (metadataType == null) {
            throw new IllegalArgumentException("Metadata type must be specified");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Input data array is null");
        }
        if (byArray.length == 0) {
            this.isDataRead = true;
        }
        this.type = metadataType;
        this.data = byArray;
    }

    @Override
    public void ensureDataRead() {
        if (!this.isDataRead) {
            try {
                this.read();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public byte[] getData() {
        if (this.data != null) {
            return (byte[])this.data.clone();
        }
        return null;
    }

    @Override
    public MetadataType getType() {
        return this.type;
    }

    @Override
    public boolean isDataRead() {
        return this.isDataRead;
    }

    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = this.getData();
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }
}

