/*
 * Decompiled with CFR 0.152.
 */
package pixy.io;

import java.io.IOException;
import java.io.OutputStream;
import pixy.io.WriteStrategy;

public class WriteStrategyII
implements WriteStrategy {
    private static final WriteStrategyII instance = new WriteStrategyII();

    public static WriteStrategyII getInstance() {
        return instance;
    }

    private WriteStrategyII() {
    }

    @Override
    public void writeInt(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[]{(byte)n2, (byte)(n2 >>> 8), (byte)(n2 >>> 16), (byte)(n2 >>> 24)};
        System.arraycopy(byArray2, 0, byArray, n, 4);
    }

    @Override
    public void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(new byte[]{(byte)n, (byte)(n >>> 8), (byte)(n >>> 16), (byte)(n >>> 24)});
    }

    @Override
    public void writeLong(byte[] byArray, int n, long l) throws IOException {
        byte[] byArray2 = new byte[]{(byte)l, (byte)(l >>> 8), (byte)(l >>> 16), (byte)(l >>> 24), (byte)(l >>> 32), (byte)(l >>> 40), (byte)(l >>> 48), (byte)(l >>> 56)};
        System.arraycopy(byArray2, 0, byArray, n, 8);
    }

    @Override
    public void writeLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write(new byte[]{(byte)l, (byte)(l >>> 8), (byte)(l >>> 16), (byte)(l >>> 24), (byte)(l >>> 32), (byte)(l >>> 40), (byte)(l >>> 48), (byte)(l >>> 56)});
    }

    @Override
    public void writeS15Fixed16Number(byte[] byArray, int n, float f) throws IOException {
        if (f < -32768.0f || f >= 32768.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException(f + " is not a valid S15Fixed16Number");
        }
        if (f == 0.0f) {
            this.writeInt(byArray, n, 0);
        } else if (f > 0.0f) {
            this.writeU16Fixed16Number(byArray, n, f);
        } else {
            int n2 = (int)Math.floor(f);
            int n3 = (int)((f - (float)n2) * 65536.0f);
            byArray[n++] = (byte)n2;
            byArray[n++] = (byte)(n2 >>> 8);
            byArray[n++] = (byte)n3;
            byArray[n] = (byte)(n3 >>> 8);
        }
    }

    @Override
    public void writeS15Fixed16Number(OutputStream outputStream, float f) throws IOException {
        if (f < -32768.0f || f >= 32768.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException(f + " is not a valid S15Fixed16Number");
        }
        if (f == 0.0f) {
            this.writeInt(outputStream, 0);
        } else if (f > 0.0f) {
            this.writeU16Fixed16Number(outputStream, f);
        } else {
            int n = (int)Math.floor(f);
            int n2 = (int)((f - (float)n) * 65536.0f);
            outputStream.write(new byte[]{(byte)n, (byte)(n >>> 8), (byte)n2, (byte)(n2 >>> 8)});
        }
    }

    @Override
    public void writeShort(byte[] byArray, int n, int n2) throws IOException {
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >>> 8);
    }

    @Override
    public void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(new byte[]{(byte)n, (byte)(n >>> 8)});
    }

    @Override
    public void writeU16Fixed16Number(byte[] byArray, int n, float f) throws IOException {
        if (f < 0.0f || f >= 65536.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException(f + " is not a valid U16Fixed16Number");
        }
        if (f == 0.0f) {
            this.writeInt(byArray, n, 0);
        } else {
            int n2 = (int)f;
            int n3 = (int)((f - (float)n2) * 65536.0f);
            byArray[n++] = (byte)n2;
            byArray[n++] = (byte)(n2 >>> 8);
            byArray[n++] = (byte)n3;
            byArray[n] = (byte)(n3 >>> 8);
        }
    }

    @Override
    public void writeU16Fixed16Number(OutputStream outputStream, float f) throws IOException {
        if (f < 0.0f || f >= 65536.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException(f + " is not a valid U16Fixed16Number");
        }
        if (f == 0.0f) {
            this.writeInt(outputStream, 0);
        } else {
            int n = (int)f;
            int n2 = (int)((f - (float)n) * 65536.0f);
            outputStream.write(new byte[]{(byte)n, (byte)(n >>> 8), (byte)n2, (byte)(n2 >>> 8)});
        }
    }

    @Override
    public void writeU8Fixed8Number(byte[] byArray, int n, float f) throws IOException {
        if (f < 0.0f || f >= 255.9961f || Float.isNaN(f)) {
            throw new IllegalArgumentException(f + " is not a valid U8ixed8Number");
        }
        if (f == 0.0f) {
            this.writeShort(byArray, n, 0);
        } else {
            int n2 = (int)f;
            int n3 = (int)((f - (float)n2) * 256.0f);
            byArray[n++] = (byte)n2;
            byArray[n] = (byte)n3;
        }
    }

    @Override
    public void writeU8Fixed8Number(OutputStream outputStream, float f) throws IOException {
        if (f < 0.0f || f >= 255.9961f || Float.isNaN(f)) {
            throw new IllegalArgumentException(f + " is not a valid U8Fixed8Number");
        }
        if (f == 0.0f) {
            this.writeShort(outputStream, 0);
        } else {
            int n = (int)f;
            int n2 = (int)((f - (float)n) * 256.0f);
            outputStream.write(new byte[]{(byte)n, (byte)n2});
        }
    }
}

