/*
 * Decompiled with CFR 0.152.
 */
package pixy.io;

import java.io.IOException;
import java.io.InputStream;
import pixy.io.IOUtils;
import pixy.io.ReadStrategy;

public class ReadStrategyII
implements ReadStrategy {
    private static final ReadStrategyII instance = new ReadStrategyII();

    public static ReadStrategyII getInstance() {
        return instance;
    }

    private ReadStrategyII() {
    }

    @Override
    public int readInt(byte[] byArray, int n) {
        return byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
    }

    @Override
    public int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        IOUtils.readFully(inputStream, byArray);
        return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    @Override
    public long readLong(byte[] byArray, int n) {
        return (long)byArray[n++] & 0xFFL | (((long)byArray[n++] & 0xFFL) << 8 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n] & 0xFFL) << 56);
    }

    @Override
    public long readLong(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8];
        IOUtils.readFully(inputStream, byArray);
        return ((long)byArray[7] & 0xFFL) << 56 | ((long)byArray[6] & 0xFFL) << 48 | ((long)byArray[5] & 0xFFL) << 40 | ((long)byArray[4] & 0xFFL) << 32 | ((long)byArray[3] & 0xFFL) << 24 | ((long)byArray[2] & 0xFFL) << 16 | ((long)byArray[1] & 0xFFL) << 8 | (long)byArray[0] & 0xFFL;
    }

    @Override
    public float readS15Fixed16Number(byte[] byArray, int n) {
        short s = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
        int n2 = byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8;
        return (float)s + (float)n2 / 65536.0f;
    }

    @Override
    public float readS15Fixed16Number(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        IOUtils.readFully(inputStream, byArray);
        short s = (short)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
        int n = byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8;
        return (float)s + (float)n / 65536.0f;
    }

    @Override
    public short readShort(byte[] byArray, int n) {
        return (short)(byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8);
    }

    @Override
    public short readShort(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        IOUtils.readFully(inputStream, byArray);
        return (short)((byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
    }

    @Override
    public float readU16Fixed16Number(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
        int n3 = byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8;
        return (float)n2 + (float)n3 / 65536.0f;
    }

    @Override
    public float readU16Fixed16Number(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        IOUtils.readFully(inputStream, byArray);
        int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
        int n2 = byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8;
        return (float)n + (float)n2 / 65536.0f;
    }

    @Override
    public float readU8Fixed8Number(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n] & 0xFF;
        return (float)n2 + (float)n3 / 256.0f;
    }

    @Override
    public float readU8Fixed8Number(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        IOUtils.readFully(inputStream, byArray);
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        return (float)n + (float)n2 / 256.0f;
    }

    @Override
    public long readUnsignedInt(byte[] byArray, int n) {
        return (long)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        IOUtils.readFully(inputStream, byArray);
        return (long)((byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF) & 0xFFFFFFFFL;
    }

    @Override
    public int readUnsignedShort(byte[] byArray, int n) {
        return byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8;
    }

    @Override
    public int readUnsignedShort(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        IOUtils.readFully(inputStream, byArray);
        return (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }
}

