/*
 * Decompiled with CFR 0.152.
 */
package pixy.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import pixy.io.RandomAccessOutputStream;

public class MemoryCacheRandomAccessOutputStream
extends RandomAccessOutputStream {
    private static final int BUFFER_SHIFT = 12;
    private static final int BUFFER_SIZE = 4096;
    private static final int BUFFER_MASK = 4095;
    private long pointer = 0L;
    private long length = 0L;
    private List<byte[]> cache = new ArrayList<byte[]>(10);
    private long cacheStart = 0L;
    private long flushPos = 0L;

    public MemoryCacheRandomAccessOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.cache.clear();
        this.cache = null;
        this.dist.close();
        this.dist = null;
        this.closed = true;
    }

    @Override
    public void disposeBefore(long l) throws IOException {
        this.ensureOpen();
        long l2 = l >> 12;
        if (l2 < this.cacheStart) {
            throw new IndexOutOfBoundsException("pos already disposed");
        }
        long l3 = Math.min(l2 - this.cacheStart, (long)this.cache.size());
        for (long i = 0L; i < l3; ++i) {
            this.cache.remove(0);
        }
        this.cacheStart = l2;
    }

    private void expandCache(long l) throws IOException {
        long l2 = this.cacheStart + (long)this.cache.size() - 1L;
        long l3 = l >> 12;
        long l4 = l3 - l2;
        for (long i = 0L; i < l4; ++i) {
            try {
                this.cache.add(new byte[4096]);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException("No memory left for cache!");
            }
        }
    }

    private byte[] getCacheBlock(long l) throws IOException {
        long l2 = l - this.cacheStart;
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("Cache addressing limit exceeded!");
        }
        return this.cache.get((int)l2);
    }

    @Override
    public long getFlushPos() {
        return this.flushPos;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getStreamPointer() {
        return this.pointer;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    @Override
    public void seek(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IOException("Negative seek position.");
        }
        this.pointer = l;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n < 0 || n2 < 0 || this.pointer < 0L || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        long l = this.pointer + (long)n2 - 1L;
        if (l >= this.length) {
            this.expandCache(l);
            this.length = l + 1L;
        }
        int n3 = (int)(this.pointer & 0xFFFL);
        while (n2 > 0) {
            byte[] byArray2 = this.getCacheBlock(this.pointer >> 12);
            int n4 = Math.min(n2, 4096 - n3);
            System.arraycopy(byArray, n, byArray2, n3, n4);
            this.pointer += (long)n4;
            n += n4;
            n2 -= n4;
            n3 = 0;
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.ensureOpen();
        if (this.pointer < 0L) {
            throw new ArrayIndexOutOfBoundsException("pointer < 0");
        }
        if (this.pointer >= this.length) {
            this.expandCache(this.pointer);
            this.length = this.pointer + 1L;
        }
        byte[] byArray = this.getCacheBlock(this.pointer >> 12);
        int n2 = (int)(this.pointer++ & 0xFFFL);
        byArray[n2] = (byte)n;
    }

    @Override
    public void writeToStream(long l) throws IOException {
        this.ensureOpen();
        if (l == 0L) {
            return;
        }
        if (this.pointer + l > this.length) {
            throw new IndexOutOfBoundsException("Argument out of cache");
        }
        if (this.pointer < 0L || l < 0L) {
            throw new IndexOutOfBoundsException("Negative pointer or len");
        }
        long l2 = this.pointer >> 12;
        if (l2 < this.cacheStart) {
            throw new IndexOutOfBoundsException("pointer already disposed");
        }
        int n = (int)(this.pointer & 0xFFFL);
        byte[] byArray = this.getCacheBlock(l2++);
        while (l > 0L) {
            if (byArray == null) {
                byArray = this.getCacheBlock(l2++);
                n = 0;
            }
            int n2 = (int)Math.min(l, (long)(4096 - n));
            this.dist.write(byArray, n, n2);
            byArray = null;
            l -= (long)n2;
            this.flushPos += (long)n2;
        }
    }

    @Override
    public void shallowClose() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.cache.clear();
        this.cache = null;
        this.dist = null;
        this.closed = true;
    }
}

