/*
 * Decompiled with CFR 0.152.
 */
package pixy.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import pixy.io.RandomAccessOutputStream;

public class FileCacheRandomAccessOutputStream
extends RandomAccessOutputStream {
    private File cacheFile;
    private RandomAccessFile cache;
    private int bufLen = 4096;
    private long length = 0L;
    private long pointer = 0L;
    private long flushPos = 0L;

    public FileCacheRandomAccessOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.cacheFile = File.createTempFile("cafe-FCRAOS-", ".tmp");
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    public FileCacheRandomAccessOutputStream(OutputStream outputStream, int n) throws IOException {
        super(outputStream);
        this.bufLen = n;
        this.cacheFile = File.createTempFile("cafe-FCRAOS-", ".tmp");
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.cache.close();
        this.cacheFile.delete();
        this.dist.close();
        this.dist = null;
        this.closed = true;
    }

    @Override
    public void disposeBefore(long l) {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    @Override
    public long getFlushPos() {
        return this.flushPos;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getStreamPointer() {
        return this.pointer;
    }

    @Override
    public void reset() {
    }

    @Override
    public void seek(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IOException("Negtive seek position.");
        }
        this.pointer = l;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n < 0 || n2 < 0 || this.pointer < 0L || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        long l = this.pointer + (long)n2 - 1L;
        if (l >= this.length) {
            this.length = l + 1L;
        }
        this.cache.seek(this.pointer);
        this.cache.write(byArray, n, n2);
        this.pointer += (long)n2;
    }

    @Override
    public void write(int n) throws IOException {
        this.ensureOpen();
        if (this.pointer < 0L) {
            throw new IndexOutOfBoundsException("pointer < 0");
        }
        if (this.pointer >= this.length) {
            this.length = this.pointer + 1L;
        }
        this.cache.seek(this.pointer);
        this.cache.write(n);
        ++this.pointer;
    }

    @Override
    public void writeToStream(long l) throws IOException {
        this.ensureOpen();
        if (l == 0L) {
            return;
        }
        if (this.pointer + l > this.length) {
            throw new IndexOutOfBoundsException("Argument out of cache");
        }
        if (this.pointer < 0L || l < 0L) {
            throw new IndexOutOfBoundsException("Negative pointer or len");
        }
        this.cache.seek(this.pointer);
        while (l > 0L) {
            byte[] byArray = new byte[this.bufLen];
            int n = this.cache.read(byArray);
            this.dist.write(byArray, 0, n);
            l -= (long)n;
            this.flushPos += (long)n;
        }
    }

    @Override
    public void shallowClose() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.cache.close();
        this.cacheFile.delete();
        this.dist = null;
        this.closed = true;
    }
}

