/*
 * Decompiled with CFR 0.152.
 */
package pixy.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import pixy.io.RandomAccessInputStream;

public class FileCacheRandomAccessInputStream
extends RandomAccessInputStream {
    private File cacheFile;
    private RandomAccessFile cache;
    private int bufLen;
    private byte[] buf;
    private long length = 0L;
    private long pointer = 0L;
    private boolean foundEOF = false;

    public FileCacheRandomAccessInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 4096);
    }

    public FileCacheRandomAccessInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream);
        this.bufLen = n;
        this.buf = new byte[n];
        this.cacheFile = File.createTempFile("cafe-FCRAIS-", ".tmp");
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    private long readUntil(long l) throws IOException {
        if (l < this.length) {
            return l;
        }
        if (this.foundEOF) {
            return this.length;
        }
        long l2 = l - this.length;
        this.cache.seek(this.length);
        while (l2 > 0L) {
            int n = this.src.read(this.buf, 0, (int)Math.min(l2, (long)this.bufLen));
            if (n == -1) {
                this.foundEOF = true;
                return this.length;
            }
            this.cache.setLength(this.cache.length() + (long)n);
            this.cache.write(this.buf, 0, n);
            l2 -= (long)n;
            this.length += (long)n;
        }
        return l;
    }

    @Override
    public long getStreamPointer() {
        return this.pointer;
    }

    @Override
    public void seek(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IOException("Negtive seek position.");
        }
        this.pointer = l;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        long l = this.pointer + 1L;
        long l2 = this.readUntil(l);
        if (l2 >= l) {
            this.cache.seek(this.pointer++);
            return this.cache.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        long l = this.readUntil(this.pointer + (long)n2);
        if ((n2 = (int)Math.min((long)n2, l - this.pointer)) > 0) {
            this.cache.seek(this.pointer);
            this.cache.readFully(byArray, n, n2);
            this.pointer += (long)n2;
            return n2;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.cache.close();
        this.cacheFile.delete();
        this.src.close();
        this.src = null;
        this.closed = true;
    }

    @Override
    public void shallowClose() throws IOException {
        if (this.closed) {
            return;
        }
        this.cache.close();
        this.cacheFile.delete();
        this.src = null;
        this.closed = true;
    }
}

