/*
 * Decompiled with CFR 0.152.
 */
package pixy.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import pixy.io.ReadStrategy;
import pixy.io.ReadStrategyMM;

public class EndianAwareInputStream
extends InputStream
implements DataInput {
    private InputStream src;
    private ReadStrategy strategy = ReadStrategyMM.getInstance();

    public EndianAwareInputStream(InputStream inputStream) {
        this.src = inputStream;
    }

    @Override
    public int read() throws IOException {
        return this.src.read();
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public char readChar() throws IOException {
        return (char)(this.readShort() & 0xFFFF);
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.src.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    @Override
    public int readInt() throws IOException {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        return this.strategy.readInt(byArray, 0);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine is not supported by RandomAccessInputStream.");
    }

    @Override
    public long readLong() throws IOException {
        byte[] byArray = new byte[8];
        this.readFully(byArray);
        return this.strategy.readLong(byArray, 0);
    }

    public float readS15Fixed16Number() throws IOException {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        return this.strategy.readS15Fixed16Number(byArray, 0);
    }

    @Override
    public short readShort() throws IOException {
        byte[] byArray = new byte[2];
        this.readFully(byArray);
        return this.strategy.readShort(byArray, 0);
    }

    public float readU16Fixed16Number() throws IOException {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        return this.strategy.readU16Fixed16Number(byArray, 0);
    }

    public float readU8Fixed8Number() throws IOException {
        byte[] byArray = new byte[2];
        this.readFully(byArray);
        return this.strategy.readU8Fixed8Number(byArray, 0);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public String readUTF() throws IOException {
        return new DataInputStream(this).readUTF();
    }

    public void setReadStrategy(ReadStrategy readStrategy) {
        this.strategy = readStrategy;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int n2 = this.src.read(new byte[n], 0, n);
        return n2;
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }
}

