/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.tiff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import pixy.image.tiff.FieldType;
import pixy.image.tiff.Tag;
import pixy.image.tiff.TiffField;
import pixy.io.RandomAccessOutputStream;
import pixy.string.StringUtils;

public final class IFD {
    private Map<Tag, IFD> children = new HashMap<Tag, IFD>();
    private Map<Short, TiffField<?>> tiffFields = new HashMap();
    private int endOffset;
    private int startOffset;

    public IFD() {
    }

    public IFD(IFD iFD) {
        this.children = Collections.unmodifiableMap(iFD.children);
        this.tiffFields = Collections.unmodifiableMap(iFD.tiffFields);
        this.startOffset = iFD.startOffset;
        this.endOffset = iFD.endOffset;
    }

    public void addChild(Tag tag, IFD iFD) {
        this.children.put(tag, iFD);
    }

    public void addField(TiffField<?> tiffField) {
        this.tiffFields.put(tiffField.getTag(), tiffField);
    }

    public void addFields(Collection<TiffField<?>> collection) {
        for (TiffField<?> tiffField : collection) {
            this.addField(tiffField);
        }
    }

    public IFD getChild(Tag tag) {
        return this.children.get(tag);
    }

    public Map<Tag, IFD> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public TiffField<?> getField(Tag tag) {
        return this.tiffFields.get(tag.getValue());
    }

    public String getFieldAsString(Tag tag) {
        TiffField<?> tiffField = this.tiffFields.get(tag.getValue());
        if (tiffField != null) {
            FieldType fieldType = tiffField.getType();
            String string = null;
            string = fieldType == FieldType.SHORT || fieldType == FieldType.SSHORT ? tag.getFieldAsString(tiffField.getDataAsLong()) : tag.getFieldAsString(tiffField.getData());
            return tiffField.getDataAsString() + (String)(StringUtils.isNullOrEmpty(string) ? "" : " => " + string);
        }
        return "";
    }

    public Collection<TiffField<?>> getFields() {
        return Collections.unmodifiableCollection(this.tiffFields.values());
    }

    public int getSize() {
        return this.tiffFields.size();
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void removeAllFields() {
        this.tiffFields.clear();
    }

    public IFD removeChild(Tag tag) {
        return this.children.remove(tag);
    }

    public TiffField<?> removeField(Tag tag) {
        return this.tiffFields.remove(tag.getValue());
    }

    public void setNextIFDOffset(RandomAccessOutputStream randomAccessOutputStream, int n) throws IOException {
        randomAccessOutputStream.seek(this.endOffset - 4);
        randomAccessOutputStream.writeInt(n);
    }

    public int write(RandomAccessOutputStream randomAccessOutputStream, int n) throws IOException {
        this.startOffset = n;
        ArrayList arrayList = new ArrayList(this.tiffFields.values());
        Collections.sort(arrayList);
        randomAccessOutputStream.seek(n);
        randomAccessOutputStream.writeShort(arrayList.size());
        int n2 = this.endOffset = (n += 2) + arrayList.size() * 12 + 4;
        randomAccessOutputStream.seek(n);
        for (TiffField object : arrayList) {
            n2 = object.write(randomAccessOutputStream, n2);
            randomAccessOutputStream.seek(n += 12);
        }
        randomAccessOutputStream.seek(n);
        randomAccessOutputStream.writeInt(0);
        if (this.children.size() > 0) {
            for (Map.Entry entry : this.children.entrySet()) {
                Tag tag = (Tag)entry.getKey();
                IFD iFD = (IFD)entry.getValue();
                TiffField<?> tiffField = this.getField(tag);
                if (tiffField == null) continue;
                int n3 = tiffField.getDataOffset();
                randomAccessOutputStream.seek(n3);
                randomAccessOutputStream.writeInt(n2);
                randomAccessOutputStream.seek(n2);
                n2 = iFD.write(randomAccessOutputStream, n2);
            }
        }
        return n2;
    }
}

