/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.tiff;

import java.io.IOException;
import pixy.image.tiff.FieldType;
import pixy.image.tiff.TiffField;
import pixy.io.RandomAccessOutputStream;

public abstract class AbstractShortField
extends TiffField<short[]> {
    public AbstractShortField(short s, FieldType fieldType, short[] sArray) {
        super(s, fieldType, sArray.length);
        this.data = sArray;
    }

    @Override
    public short[] getData() {
        return (short[])((short[])this.data).clone();
    }

    @Override
    protected int writeData(RandomAccessOutputStream randomAccessOutputStream, int n) throws IOException {
        if (((short[])this.data).length <= 2) {
            this.dataOffset = (int)randomAccessOutputStream.getStreamPointer();
            short[] sArray = new short[2];
            System.arraycopy(this.data, 0, sArray, 0, ((short[])this.data).length);
            for (short s : sArray) {
                randomAccessOutputStream.writeShort(s);
            }
        } else {
            this.dataOffset = n;
            randomAccessOutputStream.writeInt(n);
            randomAccessOutputStream.seek(n);
            for (short s : (short[])this.data) {
                randomAccessOutputStream.writeShort(s);
            }
            n += ((short[])this.data).length << 1;
        }
        return n;
    }
}

