/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.png;

import java.io.IOException;
import pixy.image.png.Chunk;
import pixy.image.png.UnknownChunk;
import pixy.util.Reader;

public class UnknownChunkReader
implements Reader {
    private int chunkValue;
    private byte[] data;
    private Chunk chunk;

    public UnknownChunkReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException("UnknownChunkReader: error reading chunk");
        }
    }

    public int getChunkValue() {
        return this.chunkValue;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void read() throws IOException {
        if (!(this.chunk instanceof UnknownChunk)) {
            throw new IllegalArgumentException("Expect UnknownChunk.");
        }
        UnknownChunk unknownChunk = (UnknownChunk)this.chunk;
        this.chunkValue = unknownChunk.getChunkValue();
        this.data = unknownChunk.getData();
    }
}

