/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.png;

import java.io.IOException;
import pixy.image.png.Chunk;
import pixy.image.png.ChunkType;
import pixy.util.Reader;

public class SRGBReader
implements Reader {
    private Chunk chunk;
    private byte renderingIntent;

    public SRGBReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.SRGB) {
            throw new IllegalArgumentException("Not a valid sRGB chunk.");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException("SRGBReader: error reading chunk");
        }
    }

    public byte getRenderingIntent() {
        return this.renderingIntent;
    }

    @Override
    public void read() throws IOException {
        byte[] byArray = this.chunk.getData();
        this.renderingIntent = byArray.length > 0 ? byArray[0] : (byte)-1;
    }
}

