/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.png;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;
import pixy.image.png.Chunk;
import pixy.image.png.ChunkType;
import pixy.io.IOUtils;
import pixy.util.Reader;

public class IDATReader
implements Reader {
    private byte[] rawData;
    private ByteArrayOutputStream byteOutput = null;

    public IDATReader() {
        this(8192);
    }

    public IDATReader(int n) {
        this.byteOutput = new ByteArrayOutputStream(n);
    }

    public IDATReader addChunk(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.IDAT) {
            throw new IllegalArgumentException("Not a valid IDAT chunk.");
        }
        try {
            this.byteOutput.write(chunk.getData());
        }
        catch (IOException iOException) {
            throw new RuntimeException("IDATReader: error adding new chunk");
        }
        return this;
    }

    public byte[] getData() throws IOException {
        if (this.rawData == null) {
            this.read();
        }
        return this.rawData;
    }

    @Override
    public void read() throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(this.byteOutput.toByteArray())));
        this.rawData = IOUtils.inputStreamToByteArray(bufferedInputStream);
        bufferedInputStream.close();
    }
}

