/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.png;

import java.io.ByteArrayOutputStream;
import java.util.zip.Deflater;
import pixy.image.png.Chunk;
import pixy.image.png.ChunkBuilder;
import pixy.image.png.ChunkType;
import pixy.util.Builder;

public class IDATBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
    private Deflater deflater = new Deflater(5);
    private boolean finish;

    public IDATBuilder() {
        super(ChunkType.IDAT);
    }

    public IDATBuilder(int n) {
        this();
        this.deflater = new Deflater(n);
    }

    public IDATBuilder data(byte[] byArray, int n, int n2) {
        this.bout.write(byArray, n, n2);
        return this;
    }

    public IDATBuilder data(byte[] byArray) {
        return this.data(byArray, 0, byArray.length);
    }

    @Override
    protected byte[] buildData() {
        int n;
        this.deflater.setInput(this.bout.toByteArray());
        this.bout.reset();
        byte[] byArray = new byte[4096];
        if (this.finish) {
            this.deflater.finish();
        }
        while (!this.deflater.finished() && (n = this.deflater.deflate(byArray)) > 0) {
            this.bout.write(byArray, 0, n);
        }
        byte[] byArray2 = this.bout.toByteArray();
        this.bout.reset();
        return byArray2;
    }

    public void setFinish(boolean bl) {
        this.finish = bl;
    }
}

