/*
 * Decompiled with CFR 0.152.
 */
package pixy.image.png;

import java.util.HashMap;
import java.util.Map;

public enum ColorType {
    GRAY_SCALE(0, "Gray-scale: each pixel is a grayscale sample."),
    TRUE_COLOR(2, "True-color: each pixel is a R,G,B triple."),
    INDEX_COLOR(3, "Index-color: each pixel is a palette index; a PLTE chunk must appear."),
    GRAY_SCALE_WITH_ALPHA(4, "Gray-scale-with-alpha: each pixel is a grayscale sample, followed by an alpha sample."),
    TRUE_COLOR_WITH_ALPHA(6, "True-color-with-alpha: each pixel is a R,G,B triple, followed by an alpha sample."),
    UNKNOWN(999, "UNKNOWN");

    private static final Map<Integer, ColorType> intMap;
    private final String description;
    private final int value;

    private ColorType(int n2, String string2) {
        this.value = n2;
        this.description = string2;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return "Image color format: " + this.getValue() + " - " + this.description;
    }

    public static ColorType fromInt(int n) {
        ColorType colorType = intMap.get(n);
        if (colorType == null) {
            return UNKNOWN;
        }
        return colorType;
    }

    static {
        intMap = new HashMap<Integer, ColorType>();
        for (ColorType colorType : ColorType.values()) {
            intMap.put(colorType.getValue(), colorType);
        }
    }
}

