/*
 * Decompiled with CFR 0.152.
 */
package pixy.image;

import java.util.HashMap;
import java.util.Map;

public enum ImageType {
    GIF("Gif"){

        @Override
        public String getExtension() {
            return "gif";
        }
    }
    ,
    PNG("Png"){

        @Override
        public String getExtension() {
            return "png";
        }
    }
    ,
    JPG("Jpeg"){

        @Override
        public String getExtension() {
            return "jpg";
        }
    }
    ,
    JPG2000("Jpeg2000"){

        @Override
        public String getExtension() {
            return "jp2";
        }
    }
    ,
    BMP("Bitmap"){

        @Override
        public String getExtension() {
            return "bmp";
        }
    }
    ,
    TGA("Targa"){

        @Override
        public String getExtension() {
            return "tga";
        }
    }
    ,
    TIFF("Tiff"){

        @Override
        public String getExtension() {
            return "tif";
        }
    }
    ,
    PCX("Pcx"){

        @Override
        public String getExtension() {
            return "pcx";
        }
    }
    ,
    UNKNOWN("Unknown"){

        @Override
        public String getExtension() {
            return null;
        }
    };

    private static final Map<String, ImageType> stringMap;
    private final String name;

    public static ImageType fromString(String string) {
        return stringMap.get(string);
    }

    private ImageType(String string2) {
        this.name = string2;
    }

    public abstract String getExtension();

    public String toString() {
        return this.name;
    }

    static {
        stringMap = new HashMap<String, ImageType>();
        for (ImageType imageType : ImageType.values()) {
            stringMap.put(imageType.toString(), imageType);
        }
    }
}

