/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.control.mediaslider;

import java.util.List;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.StringConverter;
import net.jalbum.control.mediaslider.ControlsFXControl;
import net.jalbum.control.mediaslider.MediaSliderSkin;
import net.jalbum.control.mediaslider.TimeCode;
import net.jalbum.control.mediaslider.Utils;

public class MediaSlider
extends ControlsFXControl {
    private static final StyleablePropertyFactory<MediaSlider> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
    private static final String DEFAULT_STYLE_CLASS = "media-slider";
    Supplier<String> durationTooltipSupplier = () -> "Duration: " + TimeCode.fromMillis((long)(this.getHighValue() - this.getLowValue())).toShortString();
    private DoubleProperty value;
    private BooleanProperty valueChanging;
    private DoubleProperty lowValue = new SimpleDoubleProperty((Object)this, "lowValue", 0.0){

        protected void invalidated() {
            MediaSlider.this.adjustValues();
        }
    };
    private BooleanProperty lowValueChanging;
    private DoubleProperty highValue = new SimpleDoubleProperty((Object)this, "highValue", 100.0){

        protected void invalidated() {
            MediaSlider.this.adjustValues();
        }

        public Object getBean() {
            return MediaSlider.this;
        }

        public String getName() {
            return "highValue";
        }
    };
    private BooleanProperty highValueChanging;
    private final ObjectProperty<StringConverter<Number>> tickLabelFormatter = new SimpleObjectProperty();
    private DoubleProperty max;
    private DoubleProperty min;
    private StyleableProperty<Boolean> snapToTicks = FACTORY.createStyleableBooleanProperty((Styleable)this, "snapToTicks", "-fx-snap-to-ticks", ms -> ms.snapToTicks);
    private StyleableProperty<Number> majorTickUnit = FACTORY.createStyleableNumberProperty((Styleable)this, "majorTickUnit", "-fx-major-tick-unit", ms -> ms.majorTickUnit, (Number)25.0);
    private StyleableProperty<Number> minorTickCount = FACTORY.createStyleableNumberProperty((Styleable)this, "minorTickCount", "-fx-minor-tick-count", ms -> ms.minorTickCount, (Number)3);
    private final StyleableProperty<Number> blockIncrement = FACTORY.createStyleableNumberProperty((Styleable)this, "blockIncrement", "-fx-block-increment", ms -> ms.blockIncrement, (Number)10.0);
    private final StyleableProperty<Boolean> showTickLabels = FACTORY.createStyleableBooleanProperty((Styleable)this, "showTickLabels", "-fx-show-tick-labels", ms -> ms.showTickLabels);
    private final StyleableProperty<Boolean> showTickMarks = FACTORY.createStyleableBooleanProperty((Styleable)this, "showTickMarks", "-fx-show-tick-marks", ms -> ms.showTickMarks);

    public MediaSlider() {
        this(0.0, 100.0, 0.0, 100.0, 0.0);
    }

    public MediaSlider(double min, double max, double value) {
        this(min, max, min, max, value);
    }

    public MediaSlider(double min, double max, double lowValue, double highValue, double value) {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.SLIDER);
        this.setMax(max);
        this.setMin(min);
        this.setLowValue(lowValue);
        this.setHighValue(highValue);
        this.setValue(value);
        this.adjustValues();
    }

    public Supplier<String> getDurationTooltipSupplier() {
        return this.durationTooltipSupplier;
    }

    public void setDurationTooltipSupplier(Supplier<String> durationTooltipSupplier) {
        this.durationTooltipSupplier = durationTooltipSupplier;
    }

    public String getUserAgentStylesheet() {
        return this.getUserAgentStylesheet(MediaSlider.class, "mediaslider.css");
    }

    protected Skin<?> createDefaultSkin() {
        return new MediaSliderSkin(this);
    }

    public final void setValue(double value) {
        if (!this.valueProperty().isBound()) {
            this.valueProperty().set(value);
        }
    }

    public final double getValue() {
        return this.value == null ? 0.0 : this.value.get();
    }

    public final DoubleProperty valueProperty() {
        if (this.value == null) {
            this.value = new DoublePropertyBase(0.0){

                protected void invalidated() {
                    MediaSlider.this.adjustValues();
                    MediaSlider.this.notifyAccessibleAttributeChanged(AccessibleAttribute.VALUE);
                }

                public Object getBean() {
                    return MediaSlider.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public final BooleanProperty valueChangingProperty() {
        if (this.valueChanging == null) {
            this.valueChanging = new SimpleBooleanProperty((Object)this, "valueChanging", false);
        }
        return this.valueChanging;
    }

    void setValueChanging(boolean value) {
        this.valueChangingProperty().set(value);
    }

    public boolean isValueChanging() {
        return this.valueChanging == null ? false : this.valueChanging.get();
    }

    public final DoubleProperty lowValueProperty() {
        return this.lowValue;
    }

    public final void setLowValue(double d) {
        if (!this.lowValueProperty().isBound()) {
            this.lowValueProperty().set(d);
        }
    }

    public final double getLowValue() {
        return this.lowValue != null ? this.lowValue.get() : 0.0;
    }

    public final BooleanProperty lowValueChangingProperty() {
        if (this.lowValueChanging == null) {
            this.lowValueChanging = new SimpleBooleanProperty((Object)this, "lowValueChanging", false);
        }
        return this.lowValueChanging;
    }

    public final void setLowValueChanging(boolean value) {
        this.lowValueChangingProperty().set(value);
    }

    public final boolean isLowValueChanging() {
        return this.lowValueChanging == null ? false : this.lowValueChanging.get();
    }

    public final DoubleProperty highValueProperty() {
        return this.highValue;
    }

    public final void setHighValue(double d) {
        if (!this.highValueProperty().isBound()) {
            this.highValueProperty().set(d);
        }
    }

    public final double getHighValue() {
        return this.highValue != null ? this.highValue.get() : 100.0;
    }

    public final BooleanProperty highValueChangingProperty() {
        if (this.highValueChanging == null) {
            this.highValueChanging = new SimpleBooleanProperty((Object)this, "highValueChanging", false);
        }
        return this.highValueChanging;
    }

    public final void setHighValueChanging(boolean value) {
        this.highValueChangingProperty().set(value);
    }

    public final boolean isHighValueChanging() {
        return this.highValueChanging == null ? false : this.highValueChanging.get();
    }

    public final StringConverter<Number> getLabelFormatter() {
        return (StringConverter)this.tickLabelFormatter.get();
    }

    public final void setLabelFormatter(StringConverter<Number> value) {
        this.tickLabelFormatter.set(value);
    }

    public final ObjectProperty<StringConverter<Number>> labelFormatterProperty() {
        return this.tickLabelFormatter;
    }

    public void incrementLowValue() {
        this.adjustLowValue(this.getLowValue() + this.getBlockIncrement());
    }

    public void decrementLowValue() {
        this.adjustLowValue(this.getLowValue() - this.getBlockIncrement());
    }

    public void incrementHighValue() {
        this.adjustHighValue(this.getHighValue() + this.getBlockIncrement());
    }

    public void decrementHighValue() {
        this.adjustHighValue(this.getHighValue() - this.getBlockIncrement());
    }

    public void adjustValue(double newValue) {
        double low = this.getLowValue();
        double high = this.getHighValue();
        if (high <= low) {
            return;
        }
        newValue = newValue < low ? low : newValue;
        newValue = newValue > high ? high : newValue;
        this.setValue(this.snapValueToTicks(newValue));
    }

    public void adjustLowValue(double newValue) {
        double d1 = this.getMin();
        double d2 = this.getMax();
        if (!(d2 <= d1)) {
            newValue = newValue >= d1 ? newValue : d1;
            newValue = newValue <= d2 ? newValue : d2;
            this.setLowValue(this.snapValueToTicks(newValue));
        }
    }

    public void adjustHighValue(double newValue) {
        double d1 = this.getMin();
        double d2 = this.getMax();
        if (!(d2 <= d1)) {
            newValue = newValue >= d1 ? newValue : d1;
            newValue = newValue <= d2 ? newValue : d2;
            this.setHighValue(this.snapValueToTicks(newValue));
        }
    }

    public final void setMax(double value) {
        this.maxProperty().set(value);
    }

    public final double getMax() {
        return this.max == null ? 100.0 : this.max.get();
    }

    public final DoubleProperty maxProperty() {
        if (this.max == null) {
            this.max = new DoublePropertyBase(100.0){

                protected void invalidated() {
                    if (this.get() < MediaSlider.this.getMin()) {
                        MediaSlider.this.setMin(this.get());
                    }
                    MediaSlider.this.adjustValues();
                }

                public Object getBean() {
                    return MediaSlider.this;
                }

                public String getName() {
                    return "max";
                }
            };
        }
        return this.max;
    }

    public final void setMin(double value) {
        this.minProperty().set(value);
    }

    public final double getMin() {
        return this.min == null ? 0.0 : this.min.get();
    }

    public final DoubleProperty minProperty() {
        if (this.min == null) {
            this.min = new DoublePropertyBase(0.0){

                protected void invalidated() {
                    if (this.get() > MediaSlider.this.getMax()) {
                        MediaSlider.this.setMax(this.get());
                    }
                    MediaSlider.this.adjustValues();
                }

                public Object getBean() {
                    return MediaSlider.this;
                }

                public String getName() {
                    return "min";
                }
            };
        }
        return this.min;
    }

    public final void setSnapToTicks(boolean value) {
        this.snapToTicks.setValue((Object)value);
    }

    public final boolean isSnapToTicks() {
        return this.snapToTicks == null ? false : (Boolean)this.snapToTicks.getValue();
    }

    public final BooleanProperty snapToTicksProperty() {
        return (BooleanProperty)this.snapToTicks;
    }

    public final void setMajorTickUnit(double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("MajorTickUnit cannot be less than or equal to 0.");
        }
        this.majorTickUnit.setValue((Object)value);
    }

    public final double getMajorTickUnit() {
        return this.majorTickUnit == null ? 25.0 : (Double)this.majorTickUnit.getValue();
    }

    public final ObservableValue<Double> majorTickUnitProperty() {
        return (ObservableValue)this.majorTickUnit;
    }

    public final void setMinorTickCount(int value) {
        this.minorTickCount.setValue((Object)value);
    }

    public final int getMinorTickCount() {
        return (int)(this.minorTickCount == null ? 3.0 : (Double)this.minorTickCount.getValue());
    }

    public final ObservableValue<Double> minorTickCountProperty() {
        return (ObservableValue)this.minorTickCount;
    }

    public final void setBlockIncrement(double value) {
        this.blockIncrement.setValue((Object)value);
    }

    public final double getBlockIncrement() {
        return this.blockIncrement == null ? 10.0 : (Double)this.blockIncrement.getValue();
    }

    public final ObservableValue<Double> blockIncrementProperty() {
        return (ObservableValue)this.blockIncrement;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    public final void setShowTickLabels(boolean value) {
        this.showTickLabels.setValue((Object)value);
    }

    public final boolean isShowTickLabels() {
        return this.showTickLabels == null ? false : (Boolean)this.showTickLabels.getValue();
    }

    public final ObservableValue<Boolean> showTickLabelsProperty() {
        return (ObservableValue)this.showTickLabels;
    }

    public final void setShowTickMarks(boolean value) {
        this.showTickMarks.setValue((Object)value);
    }

    public final boolean isShowTickMarks() {
        return this.showTickMarks == null ? false : (Boolean)this.showTickMarks.getValue();
    }

    public final ObservableValue<Boolean> showTickMarksProperty() {
        return (ObservableValue)this.showTickMarks;
    }

    private void adjustValues() {
        this.adjustLowValue();
        this.adjustHighValue();
        if (this.getValue() < this.getLowValue() || this.getValue() > this.getHighValue()) {
            double value = Utils.clamp(this.getLowValue(), this.getValue(), this.getHighValue());
            this.setValue(value);
        }
    }

    private void adjustLowValue() {
        if (this.getLowValue() < this.getMin() || this.getLowValue() > this.getMax()) {
            double value = Utils.clamp(this.getMin(), this.getLowValue(), this.getMax());
            this.setLowValue(value);
        } else if (this.getLowValue() >= this.getHighValue() && this.getHighValue() >= this.getMin() && this.getHighValue() <= this.getMax()) {
            double value = Utils.clamp(this.getMin(), this.getLowValue(), this.getHighValue());
            this.setLowValue(value);
        }
    }

    private double snapValueToTicks(double d) {
        double d1 = d;
        if (this.isSnapToTicks()) {
            double d2 = 0.0;
            d2 = this.getMinorTickCount() != 0 ? this.getMajorTickUnit() / (double)(Math.max(this.getMinorTickCount(), 0) + 1) : this.getMajorTickUnit();
            int i = (int)((d1 - this.getMin()) / d2);
            double d3 = (double)i * d2 + this.getMin();
            double d4 = (double)(i + 1) * d2 + this.getMin();
            d1 = Utils.nearest(d3, d1, d4);
        }
        return Utils.clamp(this.getMin(), d1, this.getMax());
    }

    private void adjustHighValue() {
        if (this.getHighValue() < this.getMin() || this.getHighValue() > this.getMax()) {
            this.setHighValue(Utils.clamp(this.getMin(), this.getHighValue(), this.getMax()));
        } else if (this.getHighValue() < this.getLowValue() && this.getLowValue() >= this.getMin() && this.getLowValue() <= this.getMax()) {
            this.setHighValue(Utils.clamp(this.getLowValue(), this.getHighValue(), this.getMax()));
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return FACTORY.getCssMetaData();
    }
}

