/*
 * Decompiled with CFR 0.152.
 */
package digfx.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Toggle;
import javafx.scene.paint.Color;

public class FXBinder {
    private static Map<Class<?>, ControlAdapter> adapters = new HashMap();
    private static DecimalFormat threeDec = new DecimalFormat("0.###");

    public static Map<String, Object> getMap(Node sceneGraph) {
        return FXBinder.getMap(sceneGraph, new HashMap<String, Object>());
    }

    public static Map<String, Object> getMap(Node sceneGraph, Map<String, Object> existing) {
        Map<String, Object> map = existing;
        FXBinder.forEach(sceneGraph, map, new ControlVisitor(){

            @Override
            public void visit(Control control, Map<String, Object> map) {
                String id = control.getId();
                if (id != null) {
                    ControlAdapter adapter = FXBinder.getAdapterForClass(control.getClass());
                    if (adapter != null) {
                        Object val = adapter.getValue(control);
                        if (val != null) {
                            map.put(id, val);
                        }
                    } else {
                        Logger.getLogger(FXBinder.class.getName()).log(Level.FINE, "Cannot bind {0}. Type {1} not registered.", new Object[]{id, control.getClass().getName()});
                    }
                }
            }
        });
        return map;
    }

    private static ControlAdapter getAdapterForClass(Class c) {
        do {
            ControlAdapter adapter;
            if ((adapter = adapters.get(c)) != null) {
                return adapter;
            }
            for (Class<?> i : c.getInterfaces()) {
                adapter = adapters.get(i);
                if (adapter == null) continue;
                return adapter;
            }
        } while ((c = c.getSuperclass()) != null && Control.class.isAssignableFrom(c));
        return null;
    }

    public static void syncUI(final Map<String, Object> map, final Node sceneGraph) {
        if (Platform.isFxApplicationThread()) {
            FXBinder.doSyncUI(map, sceneGraph);
        } else {
            final CountDownLatch counter = new CountDownLatch(1);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        FXBinder.doSyncUI(map, sceneGraph);
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                    finally {
                        counter.countDown();
                    }
                }
            });
            try {
                counter.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void doSyncUI(Map<String, Object> map, Node sceneGraph) {
        FXBinder.forEach(sceneGraph, map, new ControlVisitor(){

            @Override
            public void visit(Control control, Map<String, Object> map) {
                ControlAdapter adapter;
                String id = control.getId();
                if (id != null && (adapter = FXBinder.getAdapterForClass(control.getClass())) != null && map.containsKey(id)) {
                    adapter.setValue(control, map.get(id));
                }
            }
        });
    }

    public static void dump(Node sceneGraph) {
        FXBinder.forEach(sceneGraph, null, new ControlVisitor(){

            @Override
            public void visit(Control c, Map<String, Object> map) {
                System.out.println(c.getId() + " : " + c.getClass());
            }
        });
    }

    public <L> List<L> bar(Class<L> entry) {
        return new ArrayList();
    }

    public static <T, O> ControlAdapter<T, O> registerControl(Class<T> controlClass, ControlAdapter<T, O> adapter) {
        if (adapter != null) {
            return adapters.put(controlClass, adapter);
        }
        return adapters.remove(controlClass);
    }

    private static void forEach(Node n, Map<String, Object> map, ControlVisitor visitor) {
        if (n instanceof Control && !n.getClass().getPackage().getName().startsWith("com.sun")) {
            visitor.visit((Control)n, map);
        }
        if (n instanceof Parent) {
            for (Node c : ((Parent)n).getChildrenUnmodifiable()) {
                FXBinder.forEach(c, map, visitor);
            }
        }
    }

    static {
        FXBinder.registerControl(CheckBox.class, new ControlAdapter<CheckBox, Object>(){

            @Override
            public Boolean getValue(CheckBox control) {
                return control.isSelected();
            }

            @Override
            public void setValue(CheckBox control, Object value) {
                control.setSelected("true".equals(value.toString()));
            }
        });
        FXBinder.registerControl(Toggle.class, new ControlAdapter<Toggle, Boolean>(){

            @Override
            public Boolean getValue(Toggle control) {
                return control.isSelected();
            }

            @Override
            public void setValue(Toggle control, Boolean value) {
                control.setSelected(value.booleanValue());
            }
        });
        FXBinder.registerControl(TextInputControl.class, new ControlAdapter<TextInputControl, Object>(){

            @Override
            public Object getValue(TextInputControl control) {
                return control.getText();
            }

            @Override
            public void setValue(TextInputControl control, Object value) {
                control.setText(value.toString());
            }
        });
        FXBinder.registerControl(Slider.class, new ControlAdapter<Slider, Object>(){

            @Override
            public Double getValue(Slider control) {
                return control.getValue();
            }

            @Override
            public void setValue(Slider control, Object value) {
                if (value instanceof Number) {
                    control.setValue(((Number)value).doubleValue());
                } else {
                    control.setValue(Double.parseDouble(value.toString()));
                }
            }
        });
        FXBinder.registerControl(ComboBoxBase.class, new ControlAdapter<ComboBoxBase, Object>(){

            @Override
            public Object getValue(ComboBoxBase control) {
                Object val = control.getValue();
                if (val instanceof Enum) {
                    val = ((Enum)val).name();
                }
                return val;
            }

            @Override
            public void setValue(ComboBoxBase control, Object value) {
                control.setValue(value);
            }
        });
        FXBinder.registerControl(ComboBox.class, new ControlAdapter<ComboBox, Object>(){

            @Override
            public Object getValue(ComboBox control) {
                Object val = control.getValue();
                if (val instanceof Enum) {
                    val = ((Enum)val).name();
                }
                return val;
            }

            @Override
            public void setValue(ComboBox control, Object value) {
                Iterator iterator = control.getItems().iterator();
                while (iterator.hasNext()) {
                    Object item;
                    Object name = item = iterator.next();
                    if (item instanceof Enum && !(value instanceof Enum)) {
                        name = ((Enum)item).name();
                    }
                    if (!name.equals(value)) continue;
                    control.setValue(item);
                }
            }
        });
        FXBinder.registerControl(Spinner.class, new ControlAdapter<Spinner, Object>(){

            @Override
            public Object getValue(Spinner control) {
                return control.getValue();
            }

            @Override
            public void setValue(Spinner control, Object value) {
                if (value.toString().length() > 0) {
                    SpinnerValueFactory factory = control.getValueFactory();
                    factory.setValue(value);
                }
            }
        });
        FXBinder.registerControl(ColorPicker.class, new ControlAdapter<ColorPicker, String>(){

            @Override
            public String getValue(ColorPicker control) {
                Color c = (Color)control.getValue();
                int red = (int)(c.getRed() * 255.0);
                int green = (int)(c.getGreen() * 255.0);
                int blue = (int)(c.getBlue() * 255.0);
                if (c.getOpacity() == 1.0) {
                    return "#" + Integer.toHexString(red) + Integer.toHexString(green) + Integer.toHexString(blue);
                }
                return "rgba(" + red + "," + green + "," + blue + "," + threeDec.format(c.getOpacity()) + ")";
            }

            @Override
            public void setValue(ColorPicker control, String value) {
                control.setValue((Object)Color.web((String)value));
            }
        });
    }

    @FunctionalInterface
    private static interface ControlVisitor {
        public void visit(Control var1, Map<String, Object> var2);
    }

    public static interface ControlAdapter<UIControl, Value> {
        public Value getValue(UIControl var1);

        public void setValue(UIControl var1, Value var2);
    }
}

