/*
 * Decompiled with CFR 0.152.
 */
package digfx.scene.control;

import com.sun.javafx.collections.ObservableListWrapper;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;

public class Controls {
    private Controls() {
    }

    public static <C extends Enum> ComboBox<C> comboBox(C[] array) {
        ComboBox cb = new ComboBox((ObservableList)new ObservableListWrapper(Arrays.asList(array)));
        cb.setValue(array[0]);
        return cb;
    }

    public static <C> ComboBox<C> comboBox(C ... elements) {
        ComboBox cb = new ComboBox((ObservableList)new ObservableListWrapper(Arrays.asList(elements)));
        cb.setValue(elements[0]);
        return cb;
    }

    public static CheckBox checkBox(String text, boolean selected) {
        CheckBox cb = new CheckBox(text);
        cb.setSelected(selected);
        return cb;
    }

    public static CheckBox checkBox(boolean selected) {
        CheckBox cb = new CheckBox();
        cb.setSelected(selected);
        return cb;
    }

    public static CheckBox checkBox() {
        return new CheckBox();
    }

    public static CheckBox checkBox(String text) {
        return new CheckBox(text);
    }

    public static TextField textField() {
        return new TextField();
    }

    public static TextField textField(String text) {
        return new TextField(text);
    }

    public static TextField textField(String text, int columns) {
        TextField tf = new TextField(text);
        tf.setPrefColumnCount(columns);
        return tf;
    }

    public static TextField textField(int columns) {
        TextField tf = new TextField();
        tf.setPrefColumnCount(columns);
        return tf;
    }

    public static TextArea textArea() {
        return Controls.textArea(null, 0, 0);
    }

    public static TextArea textArea(String text) {
        return Controls.textArea(text, 0, 0);
    }

    public static TextArea textArea(String text, int rows, int columns) {
        TextArea ta = new TextArea(text);
        ta.setWrapText(true);
        ta.setPrefRowCount(rows);
        ta.setPrefColumnCount(columns);
        return ta;
    }

    public static Hyperlink hyperlink(String url, String text) {
        Hyperlink link = new Hyperlink(text);
        link.setOnAction(e -> {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException ex) {
                Logger.getLogger(Controls.class.getName()).log(Level.WARNING, null, ex);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(Controls.class.getName()).log(Level.WARNING, null, ex);
            }
        });
        return link;
    }
}

