/*
 * Decompiled with CFR 0.152.
 */
package digfx.demo;

import digfx.scene.control.Controls;
import digfx.scene.layout.RiverPane;
import digfx.util.FXBinder;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Application;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Spinner;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public class RiverPanePlay
extends Application {
    private Map<String, Object> state = new HashMap<String, Object>();
    private Map<String, Object> initialState;

    public void start(Stage primaryStage) {
        BorderPane root = new BorderPane();
        RiverPane pane = new RiverPane();
        pane.setPadding(10.0);
        Button resetButton = new Button("Reset");
        resetButton.setOnAction(e -> {
            System.out.println("Resetting state " + this.initialState);
            FXBinder.syncUI(this.initialState, (Node)pane);
        });
        Button saveButton = new Button("Save state");
        saveButton.setOnAction(e -> {
            this.state = FXBinder.getMap((Node)pane);
            System.out.println("State is " + this.state);
        });
        Button loadButton = new Button("Load state");
        loadButton.setOnAction(e -> {
            System.out.println("Loading state " + this.state);
            FXBinder.syncUI(this.state, (Node)pane);
        });
        pane.col(0).setHalignment(HPos.RIGHT);
        pane.add((Node)Controls.hyperlink("http://jalbum.net", "JAlbum AB"), HPos.RIGHT).br();
        pane.add("Registration form", HPos.CENTER);
        pane.p();
        pane.add("Name").tab().add((Node)Controls.textField("John Doe"), RiverPane.Fill.H).id("name").br();
        pane.add("Car make").tab().add((Node)Controls.comboBox("Volvo", "Saab", "Ford"), RiverPane.Fill.H).id("make").br();
        pane.add("Gender").tab().add((Node)Controls.comboBox((Enum[])Gender.values())).id("gender").br();
        pane.add("Age").tab().add((Node)new Spinner(1, 120, 20)).id("age").add("years").br();
        pane.add("Single").tab().add((Node)Controls.checkBox()).id("single").br();
        pane.add("Comment").tab().add((Node)Controls.textArea("Write someting long here..."), RiverPane.Fill.BOTH).id("comment");
        pane.p();
        pane.add((Node)saveButton, HPos.CENTER).add((Node)loadButton).add((Node)resetButton);
        root.setCenter((Node)pane);
        Scene scene = new Scene((Parent)root, 600.0, 450.0);
        primaryStage.setTitle("Demo of RiverPane and FXBinder");
        primaryStage.setScene(scene);
        primaryStage.show();
        this.initialState = FXBinder.getMap((Node)pane);
    }

    public static void main(String[] args) {
        RiverPanePlay.launch((String[])args);
    }

    public static enum Gender {
        MALE,
        FEMALE;


        public String toString() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
        }
    }
}

