/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.datareaders;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImagingException;

final class BitInputStream
extends FilterInputStream {
    private final ByteOrder byteOrder;
    private int cache;
    private int cacheBitsRemaining;
    private long bytesRead;

    BitInputStream(InputStream is, ByteOrder byteOrder) {
        super(is);
        this.byteOrder = byteOrder;
    }

    public void flushCache() {
        this.cacheBitsRemaining = 0;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public int read() throws IOException {
        if (this.cacheBitsRemaining > 0) {
            throw new ImagingException("BitInputStream: incomplete bit read");
        }
        return this.in.read();
    }

    public int readBits(int count) throws IOException {
        if (count < 8) {
            if (this.cacheBitsRemaining == 0) {
                this.cache = this.in.read();
                this.cacheBitsRemaining = 8;
                ++this.bytesRead;
            }
            if (count > this.cacheBitsRemaining) {
                throw new ImagingException("BitInputStream: can't read bit fields across bytes");
            }
            this.cacheBitsRemaining -= count;
            int bits = this.cache >> this.cacheBitsRemaining;
            switch (count) {
                case 1: {
                    return bits & 1;
                }
                case 2: {
                    return bits & 3;
                }
                case 3: {
                    return bits & 7;
                }
                case 4: {
                    return bits & 0xF;
                }
                case 5: {
                    return bits & 0x1F;
                }
                case 6: {
                    return bits & 0x3F;
                }
                case 7: {
                    return bits & 0x7F;
                }
            }
        }
        if (this.cacheBitsRemaining > 0) {
            throw new ImagingException("BitInputStream: incomplete bit read");
        }
        if (count == 8) {
            ++this.bytesRead;
            return this.in.read();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            switch (count) {
                case 16: {
                    this.bytesRead += 2L;
                    return this.in.read() << 8 | this.in.read() << 0;
                }
                case 24: {
                    this.bytesRead += 3L;
                    return this.in.read() << 16 | this.in.read() << 8 | this.in.read() << 0;
                }
                case 32: {
                    this.bytesRead += 4L;
                    return this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read() << 0;
                }
            }
        } else {
            switch (count) {
                case 16: {
                    this.bytesRead += 2L;
                    return this.in.read() << 0 | this.in.read() << 8;
                }
                case 24: {
                    this.bytesRead += 3L;
                    return this.in.read() << 0 | this.in.read() << 8 | this.in.read() << 16;
                }
                case 32: {
                    this.bytesRead += 4L;
                    return this.in.read() << 0 | this.in.read() << 8 | this.in.read() << 16 | this.in.read() << 24;
                }
            }
        }
        throw new ImagingException("BitInputStream: unknown error");
    }
}

