/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Objects;
import org.apache.commons.imaging.common.BigEndianBinaryOutputStream;
import org.apache.commons.imaging.common.LittleEndianBinaryOutputStream;

public abstract class BinaryOutputStream
extends FilterOutputStream {
    public static BigEndianBinaryOutputStream bigEndian(OutputStream outputStream) {
        return new BigEndianBinaryOutputStream(outputStream);
    }

    public static BinaryOutputStream create(OutputStream outputStream, ByteOrder byteOrder) {
        Objects.requireNonNull(outputStream, "outputStream");
        Objects.requireNonNull(byteOrder, "byteOrder");
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return BinaryOutputStream.littleEndian(outputStream);
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return BinaryOutputStream.bigEndian(outputStream);
        }
        throw new UnsupportedOperationException(byteOrder.toString());
    }

    public static LittleEndianBinaryOutputStream littleEndian(OutputStream outputStream) {
        return new LittleEndianBinaryOutputStream(outputStream);
    }

    public BinaryOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public BinaryOutputStream(OutputStream outputStream, ByteOrder byteOrder) {
        super(outputStream);
    }

    public abstract void write2Bytes(int var1) throws IOException;

    public abstract void write3Bytes(int var1) throws IOException;

    public abstract void write4Bytes(int var1) throws IOException;
}

