/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.util.concurrent.atomic.AtomicInteger;
import se.datadosen.jalbum.JAlbum;

public class WorkCounter {
    private AtomicInteger count = new AtomicInteger(0);

    public boolean waitForIdle() {
        return this.waitForIdle(0);
    }

    public synchronized boolean waitForIdle(int millisTimeout) {
        if (this.count.get() > 0) {
            long startTime = System.nanoTime();
            long elapsed = 0L;
            try {
                while (millisTimeout == 0 || (elapsed = System.nanoTime() - startTime) / 1000000L < (long)millisTimeout) {
                    this.wait((long)millisTimeout - elapsed / 1000000L);
                    if (this.count.get() != 0) continue;
                }
                if (millisTimeout > 0 && elapsed / 1000000L > (long)millisTimeout) {
                    JAlbum.logger.warning("Timeout from waitForIdle");
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    public void workStarted() {
        this.count.incrementAndGet();
        this.printState();
    }

    public int getCount() {
        return this.count.get();
    }

    public synchronized void workDone() {
        if (this.count.get() == 0) {
            throw new IllegalStateException("Calling workDone without prior workStarted");
        }
        this.count.decrementAndGet();
        this.notify();
        this.printState();
    }

    private void printState() {
    }
}

