/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import net.jalbum.component.RememberedName;
import se.datadosen.jalbum.Config;

public class WindowUtilities {
    public static void setDefaultFocus(Component c) {
        c.addHierarchyListener(e -> {
            final Component c1 = e.getComponent();
            if (c1.isShowing() && (e.getChangeFlags() & 4L) != 0L) {
                Window toplevel = SwingUtilities.getWindowAncestor(c1);
                toplevel.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        c1.requestFocusInWindow();
                    }
                });
            }
        });
    }

    private static String getWindowKey(Class<? extends Window> winClass) throws NotRememberedException {
        RememberedName a;
        String key = winClass.getSimpleName();
        if (key.equals("")) {
            key = winClass.getName();
        }
        if ((a = winClass.getAnnotation(RememberedName.class)) == null) {
            throw new NotRememberedException();
        }
        key = a.value();
        return key + ".bounds";
    }

    private static String getWindowKey(Window win) throws NotRememberedException {
        return WindowUtilities.getWindowKey(win.getClass());
    }

    public static Rectangle getSavedBounds(Window win) {
        if (Config.getConfig().isRememberWindowBounds()) {
            try {
                Preferences prefs = Preferences.userNodeForPackage(win.getClass());
                Preferences bn = prefs.node(WindowUtilities.getWindowKey(win));
                Rectangle screenBounds = win.getGraphicsConfiguration().getBounds();
                Rectangle bounds = new Rectangle(bn.getInt("x", 0), bn.getInt("y", 0), bn.getInt("width", 0), bn.getInt("height", 0));
                bounds = bounds.intersection(screenBounds);
                if (bounds.width > 0 && bounds.height > 0) {
                    return bounds;
                }
            }
            catch (NotRememberedException notRememberedException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void clearBounds(Window win) {
        try {
            Preferences prefs = Preferences.userNodeForPackage(win.getClass());
            Preferences bn = prefs.node(WindowUtilities.getWindowKey(win));
            bn.removeNode();
        }
        catch (NotRememberedException prefs) {
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean loadBounds(Window win) {
        Rectangle bounds = WindowUtilities.getSavedBounds(win);
        if (bounds != null) {
            win.setBounds(bounds);
            return true;
        }
        return false;
    }

    public static void saveBounds(Window win) {
        if (Config.getConfig().isRememberWindowBounds()) {
            try {
                Preferences prefs = Preferences.userNodeForPackage(win.getClass());
                Preferences boundsNode = prefs.node(WindowUtilities.getWindowKey(win));
                Rectangle bounds = win.getBounds();
                Rectangle screenBounds = win.getGraphicsConfiguration().getBounds();
                boundsNode.putInt("x", bounds.x);
                boundsNode.putInt("y", bounds.y);
                boundsNode.putInt("width", bounds.width);
                boundsNode.putInt("height", bounds.height);
                boundsNode.putInt("screenX", screenBounds.x);
                boundsNode.putInt("screenY", screenBounds.y);
                boundsNode.putInt("screenWidth", screenBounds.width);
                boundsNode.putInt("screenHeight", screenBounds.height);
                boundsNode.put("idString", win.getGraphicsConfiguration().getDevice().getIDstring());
            }
            catch (NotRememberedException notRememberedException) {
                // empty catch block
            }
        }
    }

    public static void stickyBounds(Window win, boolean visible) {
        if (visible) {
            WindowUtilities.loadBounds(win);
        } else {
            WindowUtilities.saveBounds(win);
        }
    }

    public static GraphicsConfiguration getLastScreen(Class<? extends Window> winClass) {
        try {
            if (winClass != null && Config.getConfig().isRememberWindowBounds()) {
                Preferences prefs = Preferences.userNodeForPackage(winClass);
                Preferences bn = prefs.node(WindowUtilities.getWindowKey(winClass));
                Point lastScreenPos = new Point(bn.getInt("screenX", 0), bn.getInt("screenY", 0));
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (GraphicsDevice screen : ge.getScreenDevices()) {
                    GraphicsConfiguration gc;
                    Point screenPos;
                    if (screen.getType() != 0 || !(screenPos = (gc = screen.getDefaultConfiguration()).getBounds().getLocation()).equals(lastScreenPos)) continue;
                    return gc;
                }
            }
        }
        catch (NotRememberedException notRememberedException) {
            // empty catch block
        }
        return null;
    }

    private static class NotRememberedException
    extends Exception {
        private NotRememberedException() {
        }
    }
}

