/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSObject;

public class WebBinder {
    public static Map<String, Object> getMap(WebEngine engine) throws IOException {
        return WebBinder.getMap(engine, new HashMap<String, Object>());
    }

    public static Map<String, Object> getMap(WebEngine engine, Map<String, Object> vars) throws IOException {
        if (Platform.isFxApplicationThread()) {
            return WebBinder.doGetMap(engine, vars);
        }
        try {
            return new FXWorker<Map>().invokeAndWait(() -> WebBinder.doGetMap(engine, vars));
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    private static JSObject getForm(WebEngine engine) throws IOException {
        Object o = engine.executeScript("document.forms[0]");
        if (!(o instanceof JSObject)) {
            throw new IOException("Skin user interface missing <form> tag");
        }
        return (JSObject)o;
    }

    private static Map<String, Object> doGetMap(WebEngine engine, Map<String, Object> vars) throws IOException {
        JSObject form = WebBinder.getForm(engine);
        JSObject elements = (JSObject)form.getMember("elements");
        Integer length = (Integer)elements.getMember("length");
        block8: for (int i = 0; i < length; ++i) {
            JSObject control = (JSObject)elements.call("item", i);
            String name = (String)control.getMember("name");
            String type = (String)control.getMember("type");
            if (name == null || name.length() <= 0 || type == null) continue;
            switch (type) {
                case "checkbox": {
                    vars.put(name, control.getMember("checked"));
                    continue block8;
                }
                case "radio": {
                    if (!Boolean.TRUE.equals(control.getMember("checked"))) continue block8;
                    vars.put(name, control.getMember("value"));
                    continue block8;
                }
                default: {
                    vars.put(name, control.getMember("value"));
                }
            }
        }
        return vars;
    }

    public static void syncUI(Map<String, Object> vars, WebEngine engine) throws IOException {
        if (Platform.isFxApplicationThread()) {
            WebBinder.doSyncUI(vars, engine);
        } else {
            try {
                new FXWorker<Void>().invokeAndWait(() -> {
                    WebBinder.doSyncUI(vars, engine);
                    return null;
                });
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw new RuntimeException(ex);
            }
        }
    }

    private static void doSyncUI(Map<String, Object> vars, WebEngine engine) throws IOException {
        JSObject form = WebBinder.getForm(engine);
        JSObject elements = (JSObject)form.getMember("elements");
        Integer length = (Integer)elements.getMember("length");
        for (Map.Entry<String, Object> e : vars.entrySet()) {
            String name = e.getKey();
            Object value = e.getValue();
            JSObject control = (JSObject)elements.call("namedItem", name);
            if (control == null) continue;
            String type = (String)control.getMember("type");
            Object before = null;
            Object after = null;
            switch (type) {
                case "checkbox": {
                    before = control.getMember("checked");
                    control.setMember("checked", value);
                    after = control.getMember("checked");
                    break;
                }
                case "file": {
                    break;
                }
                default: {
                    before = control.getMember("value");
                    control.setMember("value", value);
                    after = control.getMember("value");
                }
            }
            if (after == null || after.equals(before)) continue;
            control.call("dispatchEvent", engine.executeScript("new Event('change')"));
        }
    }

    private static class FXWorker<V> {
        private Exception ex;
        private V ret;
        private CountDownLatch workerLatch;

        private FXWorker() {
        }

        public V invokeAndWait(Callable<V> callable) throws Exception {
            this.workerLatch = new CountDownLatch(1);
            this.ex = null;
            Platform.runLater(() -> {
                try {
                    this.ret = callable.call();
                }
                catch (Exception ex) {
                    this.ex = ex;
                }
                finally {
                    this.workerLatch.countDown();
                }
            });
            try {
                this.workerLatch.await();
                if (this.ex != null) {
                    throw this.ex;
                }
                return this.ret;
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

