/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import se.datadosen.util.IO;

public class URLChecker {
    private static final int MAX_REDIRECTS = 5;

    private URLChecker() {
    }

    public static boolean exists(String urlString) throws IOException {
        return URLChecker.getResponseCode(urlString) == 200;
    }

    public static int getResponseCode(URL url) throws IOException {
        int res = URLChecker.getResponseCode(url.toString(), "HEAD");
        if (res != 200) {
            res = URLChecker.getResponseCode(url.toString(), "GET");
        }
        return res;
    }

    public static int getResponseCode(String urlString) throws IOException {
        int res = URLChecker.getResponseCode(IO.urlEncode(urlString), "HEAD");
        if (res != 200) {
            res = URLChecker.getResponseCode(IO.urlEncode(urlString), "GET");
        }
        return res;
    }

    private static int getResponseCode(String urlString, String requestMethod) throws IOException {
        int redirectsLeft = 5;
        int status = 0;
        String cookies = null;
        SSLContext ctx = null;
        do {
            URL u;
            HttpURLConnection conn;
            if ((conn = (HttpURLConnection)(u = new URL(urlString)).openConnection()) instanceof HttpsURLConnection) {
                if (ctx == null) {
                    try {
                        ctx = SSLContext.getInstance("TLS");
                        ctx.init(new KeyManager[0], new TrustManager[]{new NaiveTrustManager()}, new SecureRandom());
                    }
                    catch (KeyManagementException | NoSuchAlgorithmException ex) {
                        System.err.println(ex);
                    }
                }
                if (ctx != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(ctx.getSocketFactory());
                    ((HttpsURLConnection)conn).setHostnameVerifier((arg0, arg1) -> true);
                }
            }
            conn.setRequestMethod(requestMethod);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.63 Safari/537.36");
            conn.addRequestProperty("Accept-Language", "en-US,en;q=0.8");
            conn.addRequestProperty("Referer", "https://www.google.com");
            if (cookies != null) {
                conn.setRequestProperty("Cookie", cookies);
            }
            conn.connect();
            status = conn.getResponseCode();
            urlString = conn.getHeaderField("Location");
            cookies = conn.getHeaderField("Set-Cookie");
            conn.disconnect();
        } while (redirectsLeft-- > 0 && (status == 302 || status == 301 || status == 303));
        return status;
    }

    private static class NaiveTrustManager
    implements X509TrustManager {
        private NaiveTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

