/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import net.jalbum.util.Profiler;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.util.IO;

public class TargetPage {
    private final File file;
    private final Future<byte[]> existingContent;

    public TargetPage(File file) {
        this.file = file;
        this.existingContent = IO.workerPool.submit(() -> IO.readBytes(file));
    }

    public boolean writeChanges(String newContent, Charset charset) throws IOException {
        try (Profiler.Sample _s = Profiler.profile("Writing pages");){
            byte[] outBytes = newContent.getBytes(charset);
            try {
                if (Arrays.equals(outBytes, this.existingContent.get())) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            if (JAlbum.logger.isLoggable(Level.FINE)) {
                System.out.println("Writing page " + String.valueOf(this.file));
            }
            IO.writeBytes(outBytes, this.file);
            boolean bl = true;
            return bl;
        }
    }

    public boolean writeChanges(String newContent, String charsetName) throws IOException {
        return this.writeChanges(newContent, Charset.forName(charsetName));
    }

    public Future writeChangesBg(String newContent, Charset charset) {
        return IO.workerPool.submit(() -> {
            try {
                this.writeChanges(newContent, charset);
            }
            catch (IOException ex) {
                System.err.println("Error writing " + String.valueOf(this.file) + ": " + ex.toString());
            }
        });
    }

    public Future writeChangesBg(String newContent, String charsetName) {
        return this.writeChangesBg(newContent, Charset.forName(charsetName));
    }
}

