/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableColumnAdjuster2 {
    public static void adjustColumnWidths(JTable table) {
        for (int column = 0; column < table.getColumnCount(); ++column) {
            TableColumn tableColumn = table.getColumnModel().getColumn(column);
            int preferredWidth = TableColumnAdjuster2.getMaxColumnWidth(table, column);
            tableColumn.setPreferredWidth(preferredWidth);
        }
    }

    private static int getMaxColumnWidth(JTable table, int column) {
        int margin = 5;
        int headerWidth = TableColumnAdjuster2.getHeaderWidth(table, column);
        int cellWidth = TableColumnAdjuster2.getMaxCellWidth(table, column);
        return Math.max(headerWidth, cellWidth) + 2 * margin;
    }

    private static int getHeaderWidth(JTable table, int column) {
        TableColumn tableColumn = table.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component headerComponent = renderer.getTableCellRendererComponent(table, tableColumn.getHeaderValue(), false, false, 0, column);
        return headerComponent.getPreferredSize().width;
    }

    private static int getMaxCellWidth(JTable table, int column) {
        int maxWidth = 0;
        for (int row = 0; row < table.getRowCount(); ++row) {
            TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
            Component cellComponent = table.prepareRenderer(cellRenderer, row, column);
            int cellWidth = cellComponent.getPreferredSize().width;
            maxWidth = Math.max(maxWidth, cellWidth);
        }
        return maxWidth;
    }
}

