/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.text.DecimalFormat;
import se.datadosen.jalbum.Msg;

public class Stopwatch
implements Comparable {
    private long startTime = 0L;
    private long nanos = 0L;
    private boolean running = false;
    private String label = "";
    private long lastSample = 0L;
    private static DecimalFormat threeDec = new DecimalFormat("0.###");
    private static Stopwatch stopwatch;

    public Stopwatch() {
    }

    public Stopwatch(String label) {
        this.label = label + ": ";
    }

    public Stopwatch start() {
        if (!this.running) {
            this.startTime = System.nanoTime();
            this.running = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stopwatch stop() {
        if (this.running) {
            Stopwatch stopwatch = this;
            synchronized (stopwatch) {
                if (this.running) {
                    this.nanos += System.nanoTime() - this.startTime;
                    this.running = false;
                }
            }
        }
        return this;
    }

    public Stopwatch reset() {
        this.startTime = System.nanoTime();
        this.nanos = 0L;
        return this;
    }

    public double getSecs() {
        return (double)this.getMillis() / 1000.0;
    }

    public long getMillis() {
        if (this.running) {
            return (System.nanoTime() - this.startTime + this.nanos) / 1000000L;
        }
        return this.nanos / 1000000L;
    }

    public void setMillis(long millis) {
        this.nanos = millis * 1000000L;
    }

    public static String trace() {
        if (stopwatch == null) {
            stopwatch = new Stopwatch();
            stopwatch.start();
        }
        StackTraceElement[] elem = Thread.currentThread().getStackTrace();
        StackTraceElement last = elem[2];
        String s = " at " + last.getClassName() + "." + last.getMethodName() + "(" + last.getFileName() + ":" + last.getLineNumber() + ") " + String.valueOf(stopwatch);
        System.out.println(s);
        return s;
    }

    public String toString() {
        float secs = (float)this.getMillis() / 1000.0f;
        int mins = (int)secs / 60;
        secs -= (float)(60 * mins);
        try {
            return this.label + (String)(mins > 0 ? mins + "m " : "") + Msg.get("ui.nSecondsShort", threeDec.format(secs));
        }
        catch (Throwable ex) {
            return this.label + (String)(mins > 0 ? mins + "m " : "") + threeDec.format(secs) + "s";
        }
    }

    public void print() {
        System.out.println(this);
    }

    public String printDelta(String msg) {
        long current = this.getMillis();
        long deltaMillis = current - this.lastSample;
        this.lastSample = current;
        float secs = (float)deltaMillis / 1000.0f;
        int mins = (int)secs / 60;
        String ret = this.label + msg + ": " + (String)(mins > 0 ? mins + "m " : "") + (secs -= (float)(60 * mins)) + "s";
        System.out.println(ret);
        return ret;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int compareTo(Object o) {
        Stopwatch other = (Stopwatch)o;
        return (int)(this.getMillis() - other.getMillis());
    }
}

