/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.script.ScriptEngine;

public class ScriptExceptions {
    private static final String FILENAME_STACK = "javax.script.filename.stack";
    private static final String NAME_UNKNOWN = "<NAME_UNKNOWN>";

    private ScriptExceptions() {
    }

    public static void pushFileName(String fileName, ScriptEngine scriptEngine) {
        ScriptExceptions.getStack(scriptEngine).push(fileName);
        if (!NAME_UNKNOWN.equals(fileName)) {
            scriptEngine.getContext().setAttribute("javax.script.filename", fileName, 100);
        }
    }

    public String getCurrentFileName(ScriptEngine scriptEngine) {
        return (String)scriptEngine.getContext().getAttribute("javax.script.filename", 100);
    }

    public static void pushFileName(File file, ScriptEngine scriptEngine) {
        ScriptExceptions.pushFileName(file != null ? file.getAbsolutePath() : NAME_UNKNOWN, scriptEngine);
    }

    public static void popFileName(ScriptEngine scriptEngine) {
        Deque<String> stack = ScriptExceptions.getStack(scriptEngine);
        if (!stack.isEmpty()) {
            stack.pop();
            if (stack.peek() != null) {
                scriptEngine.getContext().setAttribute("javax.script.filename", stack.peek(), 100);
            } else {
                scriptEngine.getContext().removeAttribute("javax.script.filename", 100);
            }
        }
    }

    private static Deque<String> getStack(ScriptEngine scriptEngine) {
        ArrayDeque stack = (ArrayDeque)scriptEngine.getContext().getAttribute(FILENAME_STACK, 100);
        if (stack == null) {
            stack = new ArrayDeque();
            scriptEngine.getContext().setAttribute(FILENAME_STACK, stack, 100);
        }
        return stack;
    }
}

