/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import se.datadosen.jalbum.JavaFXInit;
import se.datadosen.jalbum.TimeCode;

public class MediaUtil {
    Media media;

    private MediaUtil() {
    }

    public static Media loadMedia(String mediaURI) throws MediaException, IOException {
        MediaUtil mu = new MediaUtil();
        return mu.doLoadMedia(mediaURI);
    }

    public static Media loadMedia(File mediaFile) throws MediaException, IOException {
        return MediaUtil.loadMedia(mediaFile.toURI().toString());
    }

    public static TimeCode getDuration(File mediaFile) {
        try {
            Media media = MediaUtil.loadMedia(mediaFile);
            Duration d = media.getDuration();
            if (d != Duration.UNKNOWN) {
                return new TimeCode(d.toMillis());
            }
        }
        catch (IOException | MediaException throwable) {
            // empty catch block
        }
        return null;
    }

    private Media doLoadMedia(String mediaURI) throws MediaException, IOException {
        JavaFXInit.ensureInitialzed();
        CountDownLatch latch = new CountDownLatch(1);
        this.media = new Media(mediaURI);
        MediaPlayer player = new MediaPlayer(this.media);
        player.setOnReady(() -> latch.countDown());
        player.setOnError(() -> latch.countDown());
        try {
            latch.await(3000L, TimeUnit.MILLISECONDS);
            if (this.media.getError() != null) {
                throw this.media.getError();
            }
            player.dispose();
            return this.media;
        }
        catch (InterruptedException ex) {
            throw new IOException("Timeout reading media from " + mediaURI);
        }
    }
}

