/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;

public class MappedAction
implements Action {
    protected Action target;
    protected Map<String, String> mapping = new HashMap<String, String>();
    protected Map<String, String> reverseMapping = new HashMap<String, String>();
    protected Map<PropertyChangeListener, PropertyChangeListener> map = new HashMap<PropertyChangeListener, PropertyChangeListener>();

    public MappedAction(Action target) {
        this.target = target;
    }

    public MappedAction(Action target, String from, String to) {
        this(target);
        this.map(from, to);
    }

    public MappedAction map(String from, String to) {
        this.mapping.put(from, to);
        if (to != null) {
            this.reverseMapping.put(to, from);
        }
        return this;
    }

    @Override
    public Object getValue(String key) {
        if (this.mapping.containsKey(key)) {
            return null;
        }
        return this.target.getValue(this.reverseMapping.getOrDefault(key, key));
    }

    @Override
    public void putValue(String key, Object value) {
        this.target.putValue(key, value);
    }

    @Override
    public void setEnabled(boolean b) {
        this.target.setEnabled(b);
    }

    @Override
    public boolean isEnabled() {
        return this.target.isEnabled();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        PropertyChangeListener mapper = evt -> listener.propertyChange(new PropertyChangeEvent(evt.getSource(), this.mapping.getOrDefault(evt.getPropertyName(), evt.getPropertyName()), evt.getOldValue(), evt.getNewValue()));
        this.target.addPropertyChangeListener(mapper);
        this.map.put(listener, mapper);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.target.removePropertyChangeListener(this.map.get(listener));
        this.map.remove(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.target.actionPerformed(e);
    }

    public static MappedAction nameToToolTip(Action a) {
        return new MappedAction(a, "Name", "ShortDescription");
    }

    public static MappedAction noIcon(Action a) {
        return new MappedAction(a, "SmallIcon", null);
    }
}

