/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import se.datadosen.util.Item;
import se.datadosen.util.LanguageMapper;

public class Languages {
    public static DefaultComboBoxModel<Item> modelFrom(File textsDir) {
        File[] files = textsDir.listFiles(file -> file.getName().endsWith(".properties"));
        ArrayList<Item> items = new ArrayList<Item>();
        for (File f : files) {
            String iso2Lang;
            String name = f.getName();
            int underscoreIndex = name.indexOf(95);
            String iso2Country = "";
            if (underscoreIndex == -1) {
                iso2Lang = "en";
            } else {
                String[] tokens = name.substring(underscoreIndex + 1, name.lastIndexOf(46)).split("_");
                iso2Lang = tokens[0];
                if (tokens.length == 2) {
                    iso2Country = tokens[1];
                }
            }
            items.add(new Item(iso2Lang, LanguageMapper.getFullName(iso2Lang) + " (" + new Locale(iso2Lang, iso2Country).getDisplayName() + ")"));
        }
        Collections.sort(items, (o1, o2) -> ((String)((Item)o1).item).compareToIgnoreCase((String)((Item)o2).item));
        DefaultComboBoxModel<Item> model = new DefaultComboBoxModel<Item>();
        for (Item item : items) {
            model.addElement(item);
        }
        return model;
    }
}

