/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.IntelliJTheme;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.MiniConfig;

public class LaF {
    private static final Map<String, IntelliJTheme> themes = new HashMap<String, IntelliJTheme>();

    public static Map<String, IntelliJTheme> getThemes() {
        return themes;
    }

    public static boolean isAnyOf(String ... ids) {
        String currentID = UIManager.getLookAndFeel().getID();
        for (String id : ids) {
            if (!currentID.contains(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDark() {
        LookAndFeel current = UIManager.getLookAndFeel();
        if (current instanceof FlatLaf) {
            return ((FlatLaf)current).isDark();
        }
        return LaF.isAnyOf("Darcula", "Dark");
    }

    private static int brightnessOf(Color c) {
        return (c.getRed() + c.getGreen() + c.getBlue()) / 3;
    }

    public static String getNameFromClassName(String lafClassName) {
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            if (!info.getClassName().equals(lafClassName)) continue;
            return info.getName();
        }
        return null;
    }

    public static String getClassNameFromName(String lafName) {
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            if (!info.getName().equals(lafName)) continue;
            return info.getClassName();
        }
        return null;
    }

    static {
        try {
            IntelliJTheme theme = new IntelliJTheme(LaF.class.getResourceAsStream("/themes/one_dark.theme.json"));
            themes.put(theme.name, theme);
            File themesDir = new File(Config.getConfig().progDir, "system/themes");
            if (themesDir.exists()) {
                for (File f : themesDir.listFiles((dir, name) -> name.endsWith(".json"))) {
                    theme = new IntelliJTheme((InputStream)new FileInputStream(f));
                    themes.put(theme.name, theme);
                }
            }
            if ((themesDir = new File(MiniConfig.getMiniConfig().configDir, "themes")).exists()) {
                for (File f : themesDir.listFiles((dir, name) -> name.endsWith(".json"))) {
                    theme = new IntelliJTheme((InputStream)new FileInputStream(f));
                    themes.put(theme.name, theme);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LaF.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

