/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import se.datadosen.util.NamedThreadFactory;

public class IdleExecutor {
    private ScheduledExecutorService delayedService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Delayed service"));
    private ScheduledFuture future;
    private int delay;
    private TimeUnit delayUnit;

    public IdleExecutor(int delayMillis, TimeUnit delayUnit) {
        this.delay = delayMillis;
        this.delayUnit = delayUnit;
    }

    public ScheduledFuture getFuture() {
        return this.future;
    }

    public void cancel() {
        this.cancel(false);
    }

    public void cancel(boolean interrupt) {
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(interrupt);
        }
    }

    public boolean isCancelled() {
        return this.future != null && this.future.isCancelled();
    }

    public Future onIdle(Runnable r) {
        this.cancel();
        this.future = this.delayedService.schedule(r, (long)this.delay, this.delayUnit);
        return this.future;
    }
}

