/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtil {
    public static String md5(String s) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(s.getBytes(), 0, s.length());
            return DigestUtil.md5(m);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String md5(File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);){
            String string = DigestUtil.md5(fis);
            return string;
        }
    }

    public static String md5(InputStream is) throws IOException {
        try {
            int len;
            MessageDigest m = MessageDigest.getInstance("MD5");
            byte[] buf = new byte[655350];
            while ((len = is.read(buf)) > 0) {
                m.update(buf, 0, len);
            }
            return DigestUtil.md5(m);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String md5(MessageDigest m) {
        String res = new BigInteger(1, m.digest()).toString(16);
        return DigestUtil.pad(res, 32, '0', true);
    }

    private static String pad(String s, int n, char c, boolean paddingLeft) {
        StringBuilder str = new StringBuilder(s);
        int strLength = str.length();
        if (n > 0 && n > strLength) {
            for (int i = 0; i <= n; ++i) {
                if (paddingLeft) {
                    if (i >= n - strLength) continue;
                    str.insert(0, c);
                    continue;
                }
                if (i <= strLength) continue;
                str.append(c);
            }
        }
        return str.toString();
    }
}

