/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.text.DecimalFormat;
import se.datadosen.jalbum.Msg;

public class DataSizeFormatter {
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long T = 0x10000000000L;
    private static final DecimalFormat fmt = new DecimalFormat("#,##0.0");
    private static final DecimalFormat fmt2Dec = new DecimalFormat("#,##0.00");
    private static final DecimalFormat thousands = new DecimalFormat("###,###,###,###");

    public static DataSize formatBytes(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Invalid size: " + value);
        }
        for (Unit u : Unit.values()) {
            long divider = u.divider;
            if (value < divider) continue;
            return DataSizeFormatter.format(value, u);
        }
        return DataSizeFormatter.format(value, Unit.B);
    }

    public static String formatXofY(String textKey, long current, long total) {
        DataSize c = DataSizeFormatter.formatBytes(current);
        DataSize t = DataSizeFormatter.formatBytes(total);
        return Msg.get(textKey, c.unit == t.unit ? c.value : c, t);
    }

    public static String groupByThousands(long value) {
        return thousands.format(value);
    }

    private static DataSize format(long value, Unit unit) {
        long divider = unit.divider;
        double result = (double)value / (double)divider;
        DecimalFormat formatter = divider >= 0x40000000L ? fmt2Dec : fmt;
        return new DataSize(formatter.format(result), unit);
    }

    public static enum Unit {
        TB(0x10000000000L),
        GB(0x40000000L),
        MB(0x100000L),
        KB(1024L),
        B(1L);

        private final long divider;
        private final String translatedUnit;

        private Unit(long divider) {
            this.divider = divider;
            this.translatedUnit = Msg.get("unit." + this.name());
        }

        public long getDivider() {
            return this.divider;
        }

        public String toString() {
            return this.translatedUnit;
        }
    }

    public static class DataSize {
        public final String value;
        public final Unit unit;

        public DataSize(String value, Unit unit) {
            this.value = value;
            this.unit = unit;
        }

        public String toString() {
            return this.value + " " + String.valueOf((Object)this.unit);
        }
    }
}

