/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import se.datadosen.component.JPlainButton;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.Debug;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.Text;

public class ContextHelp {
    public static final String HELP_PAGE = "helpPage";
    private static ContextHelp theInstance;
    private final Map<Window, WindowHelpContext> contexts = new WeakHashMap<Window, WindowHelpContext>();
    private final HierarchyListener listener = e -> {
        Window window;
        if ((e.getChangeFlags() & 4L) != 0L && (window = SwingUtilities.windowForComponent(e.getComponent())) != null) {
            if (e.getComponent().isShowing()) {
                this.getContext(window).componentVisible((JComponent)e.getComponent());
            } else {
                this.getContext(window).componentHidden((JComponent)e.getComponent());
            }
        }
    };

    protected ContextHelp() {
    }

    public static ContextHelp getInstance() {
        if (theInstance == null) {
            theInstance = new ContextHelp();
        }
        return theInstance;
    }

    public static void setInstance(ContextHelp instance) {
        theInstance = instance;
    }

    protected void open(String helpPage) {
        try {
            Object fullPath = JAlbumSite.getInstance().getHelpUrl() + "/jAlbum/" + helpPage;
            if (helpPage.indexOf(58) != -1) {
                fullPath = helpPage;
            }
            Desktop.getDesktop().browse(URI.create((String)fullPath));
            Tracer.getInstance().trace("context help", new String[]{fullPath});
        }
        catch (IOException ex) {
            Debug.showFriendlyErrorDialog(null, ex);
        }
    }

    public void add(JComponent comp, String helpPage) {
        comp.putClientProperty(HELP_PAGE, helpPage);
        comp.removeHierarchyListener(this.listener);
        comp.addHierarchyListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTree(JComponent container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.addTree(container, container.getComponents());
        }
    }

    private void addTree(JComponent container, Component[] components) {
        if (container instanceof JPanel && ContextHelp.getHelpPageFor(container) != null) {
            container.removeHierarchyListener(this.listener);
            container.addHierarchyListener(this.listener);
        }
        for (Component comp : components) {
            if (!(comp instanceof JComponent)) continue;
            JComponent child = (JComponent)comp;
            this.addTree(child, child.getComponents());
        }
    }

    private static String getHelpPageFor(JComponent comp) {
        return (String)comp.getClientProperty(HELP_PAGE);
    }

    public void remove(JComponent comp) {
        comp.removeHierarchyListener(this.listener);
        comp.putClientProperty(HELP_PAGE, null);
    }

    public void installHelpButton(JFrame frame, Corner corner) {
        this.installHelpButton(frame, corner, 5);
    }

    public void installHelpButton(JFrame frame, Corner corner, int margin) {
        this.getContext(frame).installHelpButton(corner, margin);
    }

    public void installHelpButton(JDialog dialog, Corner corner) {
        this.installHelpButton(dialog, corner, 5);
    }

    public void installHelpButton(JDialog dialog, Corner corner, int margin) {
        this.getContext(dialog).installHelpButton(corner, margin);
    }

    public WindowHelpContext getContext(Window window) {
        WindowHelpContext ctx = this.contexts.get(window);
        if (ctx == null) {
            ctx = new WindowHelpContext(window);
            this.contexts.put(window, ctx);
        }
        return ctx;
    }

    private static int levelOf(Component comp) {
        if (comp.getParent() == null) {
            return 0;
        }
        return 1 + ContextHelp.levelOf(comp.getParent());
    }

    public static enum Corner {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT,
        TOP_LEFT;

    }

    public class WindowHelpContext {
        private static final String CONTEXT_HELP_KEY = "contextHelpKey";
        private Window window;
        private final Set<JComponent> visibleComponents = new HashSet<JComponent>();
        @Text(value="ui.helpMenu")
        private final Action helpAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.small("help"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = WindowHelpContext.this.getHelpPath();
                if (path != null) {
                    ContextHelp.this.open(path);
                }
            }
        };
        private final JButton helpButton = new JPlainButton(this.helpAction, false, 2);

        public WindowHelpContext(Window window) {
            if (!(window instanceof JFrame) && !(window instanceof JDialog)) {
                throw new IllegalArgumentException("window must be either a JFrame or JDialog instance");
            }
            this.window = window;
            this.helpButton.setVisible(false);
            Msg.maintainTranslated(this);
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(112, 0), CONTEXT_HELP_KEY);
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(156, 0), CONTEXT_HELP_KEY);
            this.getRootPane().getActionMap().put(CONTEXT_HELP_KEY, this.helpAction);
        }

        public JButton getHelpButton() {
            return this.helpButton;
        }

        public Action getHelpAction() {
            return this.helpAction;
        }

        private void installHelpButton(Corner corner, int margin) {
            JPanel panel = (JPanel)this.getRootPane().getGlassPane();
            panel.removeAll();
            panel.setLayout(new BorderLayout());
            int yMargin = 0;
            if (Platform.isWindows() && Boolean.TRUE.equals(UIManager.get("TitlePane.useWindowDecorations"))) {
                Dimension dim = (Dimension)UIManager.get("TitlePane.buttonSize");
                yMargin = dim != null ? dim.height : 30;
            }
            panel.setBorder(BorderFactory.createEmptyBorder(yMargin + margin, margin, margin, margin));
            JPanel inner = new JPanel(new BorderLayout());
            inner.setOpaque(false);
            switch (corner.ordinal()) {
                case 0: 
                case 3: {
                    panel.add((Component)inner, "North");
                    break;
                }
                default: {
                    panel.add((Component)inner, "South");
                }
            }
            switch (corner.ordinal()) {
                case 2: 
                case 3: {
                    inner.add((Component)this.helpButton, "West");
                    break;
                }
                default: {
                    inner.add((Component)this.helpButton, "East");
                }
            }
            panel.validate();
            panel.setVisible(true);
        }

        private JRootPane getRootPane() {
            if (this.window instanceof JFrame) {
                return ((JFrame)this.window).getRootPane();
            }
            return ((JDialog)this.window).getRootPane();
        }

        private void componentVisible(JComponent comp) {
            this.visibleComponents.add(comp);
            this.visibilityChanged();
        }

        private void componentHidden(JComponent comp) {
            this.visibleComponents.remove(comp);
            this.visibilityChanged();
        }

        private void visibilityChanged() {
            this.helpButton.setVisible(this.getHelpPath() != null);
        }

        public String getHelpPath() {
            JComponent deepest = null;
            int deepestLevel = 0;
            for (JComponent c : this.visibleComponents) {
                int level = ContextHelp.levelOf(c);
                if (deepest == null) {
                    deepest = c;
                    deepestLevel = level;
                    continue;
                }
                if (level <= deepestLevel) continue;
                deepest = c;
                deepestLevel = level;
            }
            return deepest != null ? ContextHelp.getHelpPageFor(deepest) : null;
        }

        public int hashCode() {
            return this.window.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WindowHelpContext other = (WindowHelpContext)obj;
            return this.window == other.window || this.window != null && this.window.equals(other.window);
        }
    }
}

