/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public final class BlockingLifoQueue<T>
implements BlockingQueue<T> {
    private final BlockingDeque<T> deque = new LinkedBlockingDeque<T>();

    @Override
    public boolean add(T e) {
        this.deque.addLast(e);
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.deque.contains(o);
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        return this.deque.drainTo(c);
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        return this.deque.drainTo(c, maxElements);
    }

    @Override
    public boolean offer(T e) {
        return this.deque.offerLast(e);
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.deque.offerLast(e, timeout, unit);
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.deque.pollLast(timeout, unit);
    }

    @Override
    public void put(T e) throws InterruptedException {
        this.deque.putLast(e);
    }

    @Override
    public int remainingCapacity() {
        return this.deque.size();
    }

    @Override
    public boolean remove(Object o) {
        return this.deque.remove(o);
    }

    @Override
    public T take() throws InterruptedException {
        return this.deque.takeLast();
    }

    @Override
    public T element() {
        if (this.deque.isEmpty()) {
            throw new NoSuchElementException("empty stack");
        }
        return (T)this.deque.pollLast();
    }

    @Override
    public T peek() {
        return (T)this.deque.peekLast();
    }

    @Override
    public T poll() {
        return (T)this.deque.pollLast();
    }

    @Override
    public T remove() {
        if (this.deque.isEmpty()) {
            throw new NoSuchElementException("empty stack");
        }
        return (T)this.deque.pollLast();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T e : c) {
            this.deque.add(e);
        }
        return true;
    }

    @Override
    public void clear() {
        this.deque.clear();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.deque.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.deque.descendingIterator();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.deque.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.deque.retainAll(c);
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public Object[] toArray() {
        return this.deque.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.deque.toArray(a);
    }
}

