/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.tags;

import java.io.File;
import java.util.Objects;

public class Section {
    private final String doc;
    private String sec;
    private final int beginIndex;
    private final int endIndex;
    private File sourceFile;
    private boolean manipulated;

    public Section(String doc, int beginIndex, int endIndex, File sourceFile) {
        if (doc == null) {
            throw new NullPointerException("Passing null doc");
        }
        this.doc = doc;
        this.sec = doc.substring(beginIndex, endIndex);
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.sourceFile = sourceFile;
        this.validate();
    }

    public Section(String doc, int beginIndex, int endIndex) {
        this(doc, beginIndex, endIndex, null);
    }

    public Section derive(String s) {
        Section derived = new Section(this.doc, this.beginIndex, this.endIndex, this.sourceFile);
        derived.sec = s;
        derived.manipulated = true;
        return derived;
    }

    public Section(String doc) {
        this(doc, 0, doc.length());
    }

    public Section(String doc, File sourceFile) {
        this(doc, 0, doc.length());
        this.setSourceFile(sourceFile);
    }

    public Section(String doc, int beginIndex) {
        this(doc, beginIndex, doc.length());
    }

    Section replaceSection(String newSection) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.doc, 0, this.beginIndex);
        builder.append(newSection);
        builder.append(this.doc, this.endIndex, this.doc.length());
        Section newSec = new Section(builder.toString(), this.beginIndex, this.beginIndex + newSection.length(), this.sourceFile);
        return newSec;
    }

    public Section subsection(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > this.length()) {
            throw new StringIndexOutOfBoundsException("Section beginIndex out of range: " + beginIndex);
        }
        if (endIndex < beginIndex || endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException("Section endIndex out of range: " + endIndex);
        }
        if (this.manipulated) {
            return this.derive(this.sec.substring(beginIndex, endIndex));
        }
        return new Section(this.doc, this.beginIndex + beginIndex, this.beginIndex + endIndex, this.sourceFile);
    }

    public Section subsection(int beginIndex) {
        return this.subsection(beginIndex, this.length());
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getSourceLineNumber(int index) {
        int targetIndex = this.beginIndex + index;
        char[] chars = this.doc.toCharArray();
        int line = 1;
        for (int i = 0; i < chars.length && i < targetIndex; ++i) {
            if (chars[i] != '\n') continue;
            ++line;
        }
        return line;
    }

    public int getSourceColumn(int index) {
        int targetIndex = this.beginIndex + index;
        char[] chars = this.doc.toCharArray();
        int line = 1;
        int col = 1;
        int i = 0;
        while (i < chars.length && i < targetIndex) {
            if (chars[i] == '\n') {
                ++line;
                col = 0;
            } else if (chars[i] == '\r') {
                col = 0;
            }
            ++i;
            ++col;
        }
        return col;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public char charAt(int index) {
        return this.sec.charAt(index);
    }

    public int indexOf(int ch, int fromIndex) {
        return this.sec.indexOf(ch, fromIndex);
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return this.sec.indexOf(str, fromIndex);
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public boolean startsWith(String prefix, int toffset) {
        return this.sec.startsWith(prefix, toffset);
    }

    public String toString() {
        return this.sec;
    }

    public int hashCode() {
        return this.sec.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Section other = (Section)obj;
        return Objects.equals(this.sec, other.sec);
    }

    public int length() {
        return this.sec.length();
    }

    private void validate() {
        if (this.beginIndex < 0 || this.beginIndex > this.doc.length()) {
            throw new StringIndexOutOfBoundsException("Section beginIndex out of range: " + this.beginIndex);
        }
        if (this.endIndex < this.beginIndex || this.endIndex > this.doc.length()) {
            throw new StringIndexOutOfBoundsException("Section endIndex out of range: " + this.endIndex);
        }
    }
}

