/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.net;

import java.io.IOException;
import java.net.InetAddress;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import net.sbbi.upnp.messages.UPNPResponseException;
import se.datadosen.net.PortMappingListener;

public class PortMapping {
    private String description;
    private int port;
    private String externalAddress;
    private InternetGatewayDevice gateway;
    private boolean mapped = false;
    private Thread deletePortMappingHook;
    private PortMappingListener listener;

    public PortMapping(String description, int port) throws IOException, UPNPResponseException {
        this(description, port, null);
    }

    public PortMapping(String description, int port, PortMappingListener listener) throws IOException, UPNPResponseException {
        this.description = description;
        this.listener = listener;
        int discoveryTimeout = 5000;
        listener.statusChanged("Searching for gateway...");
        InternetGatewayDevice[] IGDs = InternetGatewayDevice.getDevices((int)discoveryTimeout);
        if (IGDs == null) {
            throw new IOException("No UPnP enabled gateway found");
        }
        this.gateway = IGDs[0];
        listener.statusChanged("Found device " + this.gateway.getIGDRootDevice().getModelName() + " out of " + IGDs.length + " devices");
        System.out.println("Gateway def loc: " + String.valueOf(this.gateway.getIGDRootDevice().getDeviceDefLoc()));
        this.setMapping(port);
    }

    public int getPort() {
        return this.port;
    }

    public void setMapping(int port) throws UPNPResponseException, IOException {
        if (this.mapped) {
            this.deletePortMapping();
        }
        this.port = port;
        String localHostIP = InetAddress.getLocalHost().getHostAddress();
        this.mapped = this.gateway.addPortMapping(this.description, null, port, port, localHostIP, 0, "TCP");
        if (this.mapped) {
            this.deletePortMappingHook = new Thread(){

                @Override
                public void run() {
                    PortMapping.this.deletePortMapping(false);
                }
            };
            Runtime.getRuntime().addShutdownHook(this.deletePortMappingHook);
            this.listener.statusChanged("Port " + port + " mapped to " + localHostIP);
        }
    }

    public String getExternalAddress() throws IOException, UPNPResponseException {
        if (this.externalAddress == null) {
            this.externalAddress = this.gateway.getExternalIPAddress();
        }
        return this.externalAddress;
    }

    public boolean deletePortMapping() {
        return this.deletePortMapping(true);
    }

    private boolean deletePortMapping(boolean removeHook) {
        if (removeHook && this.deletePortMappingHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.deletePortMappingHook);
            this.deletePortMappingHook = null;
        }
        try {
            boolean success = this.gateway.deletePortMapping(null, this.port, "TCP");
            boolean bl = this.mapped = !success;
            if (success) {
                this.listener.statusChanged("Deleted port mapping for port " + this.port);
            }
            return success;
        }
        catch (IOException | UPNPResponseException throwable) {
            return false;
        }
    }
}

