/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.net;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.Optional;

public class NetUtil {
    private NetUtil() {
    }

    public static boolean isLocal(URL url) {
        String host = url.getHost();
        return url.getProtocol().equals("file") || host.equals("127.0.0.1") || host.equals("localhost") || host.equals(NetUtil.getLocalHostAddress());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalHostAddress() {
        try (DatagramSocket datagramSocket = new DatagramSocket();){
            datagramSocket.connect(InetAddress.getByName("8.8.8.8"), 12345);
            String hostAddress = datagramSocket.getLocalAddress().getHostAddress();
            if (!"0.0.0.0".equals(hostAddress)) {
                String string = hostAddress;
                return string;
            }
            Optional<InetAddress> address = NetworkInterface.getByName("en0").inetAddresses().filter(a -> a.getClass() == Inet4Address.class).findFirst();
            String string = address.orElseThrow().getHostAddress();
            return string;
        }
        catch (UncheckedIOException | SocketException | UnknownHostException ex) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (NullPointerException | UnknownHostException | NoSuchElementException ex1) {
                return "127.0.0.1";
            }
        }
    }

    public static int getFreeServerPort(int suggestedPort) {
        int n;
        ServerSocket s = new ServerSocket(suggestedPort);
        try {
            n = suggestedPort;
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return NetUtil.getFreeServerPort(suggestedPort + 1);
            }
        }
        s.close();
        return n;
    }

    public static int getFreeServerPort() {
        int port = 5001;
        byte[] ip = null;
        try {
            ip = InetAddress.getLocalHost().getAddress();
            port = 5000 + ip[3];
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        boolean firstOk = true;
        return port;
    }
}

