/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.net;

import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import se.datadosen.net.PingServlet;
import se.datadosen.net.SameFileAliasChecker;
import se.datadosen.net.Share;

public class JettyHttpServer {
    public static final String PING_SERVLET_URI = "/PingServlet";
    protected Server server = new Server();
    protected ServerConnector connector = new ServerConnector(this.server);
    private Set<Share> shares = new TreeSet<Share>();
    private Thread stopServerHook;

    public JettyHttpServer() {
        this.connector.setIdleTimeout(30000L);
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler((Handler)new HandlerCollection(true, new Handler[0]));
    }

    public String getHost() {
        return this.connector.getHost();
    }

    public void setHost(String host) {
        this.connector.setHost(host);
    }

    public void setPort(int port) {
        this.connector.setPort(port);
    }

    public int getPort() {
        return this.connector.getPort();
    }

    private static SecurityHandler basicAuth(String userName, String password, String realm) {
        HashLoginService l = new HashLoginService();
        UserStore userStore = new UserStore();
        userStore.addUser(userName, (Credential)new Password(password), new String[]{"users"});
        l.setUserStore(userStore);
        l.setName(realm);
        Constraint constraint = new Constraint("BASIC", "users");
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName(realm);
        csh.addConstraintMapping(cm);
        csh.setLoginService((LoginService)l);
        return csh;
    }

    public void setShares(Set<Share> shares) {
        this.setShares(shares, null);
    }

    public void setShares(Set<Share> shares, String cacheControl) {
        this.shares = shares;
        PingServlet _pingServlet = new PingServlet();
        HandlerCollection handlers = (HandlerCollection)this.server.getHandler();
        for (Handler h : handlers.getChildHandlers()) {
            handlers.removeHandler(h);
        }
        for (Share share : shares) {
            if (!share.active) continue;
            ServletContextHandler ch = new ServletContextHandler();
            ch.setContextPath(share.uri);
            ch.setResourceBase(share.localPath);
            ch.addAliasCheck((ContextHandler.AliasCheck)new SameFileAliasChecker());
            ResourceHandler rh = new ResourceHandler();
            rh.setDirAllowed(false);
            if (cacheControl != null) {
                rh.setCacheControl(cacheControl);
            }
            ch.setHandler((Handler)rh);
            ServletContextHandler newHandler = ch;
            if (share.passwordProtect && share.userName != null && share.password != null) {
                SecurityHandler sh = JettyHttpServer.basicAuth(share.userName, share.password, share.uri);
                sh.setHandler((Handler)ch);
                newHandler = sh;
            }
            handlers.addHandler((Handler)newHandler);
            if (!this.server.isStarted()) continue;
            try {
                newHandler.start();
            }
            catch (Exception ex) {
                Logger.getLogger(JettyHttpServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ServletContextHandler context = new ServletContextHandler(0);
        context.setContextPath("/");
        context.setResourceBase(System.getProperty("java.io.tmpdir"));
        context.addServlet(PingServlet.class, PING_SERVLET_URI);
        handlers.addHandler((Handler)context);
    }

    public Set<Share> getShares() {
        return this.shares;
    }

    public void start() throws Exception {
        this.server.start();
        this.stopServerHook = new Thread(){

            @Override
            public void run() {
                try {
                    JettyHttpServer.this.server.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.stopServerHook);
    }

    public void stop() throws Exception {
        this.server.stop();
        if (this.stopServerHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.stopServerHook);
        }
        this.stopServerHook = null;
    }

    public boolean isRunning() {
        return this.server.isStarted();
    }

    static {
        Log.setLog((org.eclipse.jetty.util.log.Logger)new org.eclipse.jetty.util.log.Logger(){

            public String getName() {
                return "No logger";
            }

            public void warn(String string, Object ... os) {
            }

            public void warn(Throwable thrwbl) {
            }

            public void warn(String string, Throwable thrwbl) {
            }

            public void info(String string, Object ... os) {
            }

            public void info(Throwable thrwbl) {
            }

            public void info(String string, Throwable thrwbl) {
            }

            public boolean isDebugEnabled() {
                return false;
            }

            public void setDebugEnabled(boolean bln) {
            }

            public void debug(String string, Object ... os) {
            }

            public void debug(String string, long l) {
            }

            public void debug(Throwable thrwbl) {
            }

            public void debug(String string, Throwable thrwbl) {
            }

            public org.eclipse.jetty.util.log.Logger getLogger(String string) {
                return this;
            }

            public void ignore(Throwable thrwbl) {
            }
        });
    }
}

