/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.videoplayer;

import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.concurrent.Callable;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.util.Duration;
import javax.swing.Icon;
import net.jalbum.control.mediaslider.MediaSlider;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.FXIcons;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.jalbum.videoplayer.VideoPlayer;

public class MediaControl
extends BorderPane {
    private MediaPlayer mp;
    private MediaView mediaView;
    private final boolean repeat = false;
    private boolean stopRequested = false;
    private boolean atEndOfMedia = false;
    private Duration duration;
    private MediaSlider timeSlider;
    private Label playTime;
    private Slider volumeSlider;
    private HBox mediaBar = new HBox();
    private final Duration delay = Duration.seconds((double)4.0);
    private final Duration halfSecond = Duration.millis((double)500.0);
    private final FadeTransition fader = new FadeTransition(Duration.millis((double)200.0), (Node)this.mediaBar);
    private final Transition delayedFader;
    private static final Node videoBeginIcon = FXIcons.get("videoplayer_video-begin");
    private static final Node playIcon = FXIcons.get("videoplayer_play");
    private static final Node pauseIcon = FXIcons.get("videoplayer_pause");
    private static final Node cameraIcon = FXIcons.get("videoplayer_camera");
    private static final Node volumeDownIcon = FXIcons.get("volume-down-white");
    private static final Node volumeUpIcon = FXIcons.get("volume-up-white");
    private static final Node fullScreenIcon = FXIcons.get("videoplayer_fullscreen");
    private static final Node fullScreenExitIcon = FXIcons.get("videoplayer_exit-fullscreen");
    private final VideoPlayer videoPlayer;
    boolean userTriggered;

    private void mouseEventDetected() {
        if (this.delayedFader.getStatus() != Animation.Status.PAUSED && this.delayedFader.getCurrentTime().greaterThan(this.halfSecond)) {
            this.delayedFader.playFromStart();
        }
    }

    private void cancelFader() {
        this.delayedFader.jumpTo(Duration.ZERO);
        this.delayedFader.pause();
    }

    public final void onHide() {
        this.mp.stop();
        this.mp.dispose();
        this.videoPlayer.mediaPlayerProcessor.dispose();
        AlbumObjectProperties props = this.videoPlayer.ao.getProperties();
        TimeCode clipStart = TimeCode.fromMillis((long)this.timeSlider.getLowValue());
        TimeCode clipLength = TimeCode.fromMillis((long)(this.timeSlider.getHighValue() - this.timeSlider.getLowValue()));
        TimeCode origClipStart = props.get("videoClipStart", new TimeCode(0));
        TimeCode origClipLength = props.get("videoClipLength", TimeCode.fromMillis((long)this.duration.toMillis()));
        if (!clipStart.equals(origClipStart) || !clipLength.equals(origClipLength)) {
            props.put("videoClipStart", clipStart);
            props.put("videoClipLength", clipLength);
            props.save(false);
            this.videoPlayer.ao.getFile().setLastModified(new Date().getTime());
        }
    }

    public MediaControl(VideoPlayer vp, final MediaPlayer mp) {
        this.fader.setFromValue(1.0);
        this.fader.setToValue(0.0);
        this.delayedFader = new SequentialTransition(new Animation[]{new PauseTransition(this.delay), this.fader});
        this.userTriggered = true;
        this.videoPlayer = vp;
        this.mp = mp;
        this.mediaView = new MediaView(mp);
        this.setStyle("-fx-background-color: black;");
        Pane mvPane = new Pane();
        mvPane.setStyle("-fx-background-color: black;");
        mvPane.getChildren().add((Object)this.mediaView);
        this.setCenter((Node)mvPane);
        this.mediaBar.setStyle("-fx-background-color: rgba(0,0,0,0.4); -fx-background-radius: 8; -fx-padding: 50px; -fx-background-insets: 35px;");
        this.mediaBar.setAlignment(Pos.CENTER);
        BorderPane.setAlignment((Node)this.mediaBar, (Pos)Pos.CENTER);
        Button playButton = new Button();
        playButton.setGraphic(playIcon);
        playButton.setBackground(Background.EMPTY);
        playButton.setOnAction(e -> {
            MediaPlayer.Status status;
            if (mp.getCurrentTime().toMillis() >= this.timeSlider.getHighValue()) {
                mp.seek(Duration.millis((double)this.timeSlider.getLowValue()));
            }
            if ((status = mp.getStatus()) == MediaPlayer.Status.UNKNOWN || status == MediaPlayer.Status.HALTED) {
                return;
            }
            if (status == MediaPlayer.Status.PAUSED || status == MediaPlayer.Status.READY || status == MediaPlayer.Status.STOPPED) {
                if (this.atEndOfMedia) {
                    mp.seek(mp.getStartTime());
                    this.atEndOfMedia = false;
                }
                mp.play();
            } else {
                mp.pause();
            }
        });
        this.addEventHandler(KeyEvent.KEY_PRESSED, ev -> {
            switch (ev.getCode()) {
                case SPACE: {
                    playButton.fire();
                    break;
                }
                case W: {
                    if (ev.isShortcutDown()) {
                        this.getScene().getWindow().hide();
                        this.onHide();
                        break;
                    }
                }
                case F4: {
                    if (!ev.isAltDown()) break;
                    this.getScene().getWindow().hide();
                    this.onHide();
                }
            }
            ev.consume();
        });
        EventHandler mouseExited = e -> {
            this.delayedFader.jumpTo(this.delay);
            this.delayedFader.play();
        };
        this.setOnMouseExited(mouseExited);
        mp.currentTimeProperty().addListener(ov -> this.updateValues());
        mp.setOnPlaying(() -> {
            if (this.stopRequested) {
                mp.pause();
                this.stopRequested = false;
            } else {
                playButton.setGraphic(pauseIcon);
            }
        });
        mp.setOnPaused(() -> playButton.setGraphic(playIcon));
        mp.setOnReady(() -> {
            this.duration = mp.getMedia().getDuration();
            this.timeSlider.setMax(this.duration.toMillis());
            AlbumObjectProperties props = this.videoPlayer.ao.getProperties();
            TimeCode clipStart = props.get("videoClipStart", new TimeCode(0));
            TimeCode clipLength = props.get("videoClipLength", TimeCode.fromMillis((long)this.duration.toMillis()));
            this.timeSlider.setHighValue((double)(clipStart.asMillis() + clipLength.asMillis()));
            this.timeSlider.setValue((double)clipStart.asMillis());
            this.timeSlider.setLowValue((double)clipStart.asMillis());
            this.updateValues();
        });
        mp.setCycleCount(1);
        mp.setOnEndOfMedia(() -> {
            playButton.setGraphic(playIcon);
            this.stopRequested = true;
            this.atEndOfMedia = true;
        });
        Button snapshotButton = new Button();
        snapshotButton.setFocusTraversable(false);
        snapshotButton.setGraphic(cameraIcon);
        snapshotButton.setBackground(Background.EMPTY);
        snapshotButton.setTooltip(new Tooltip(Msg.get("ui.setThumbnail")));
        snapshotButton.setOnAction(e -> this.videoPlayer.createSnapshot(TimeCode.fromMillis((long)this.timeSlider.getValue())));
        Button videoStartButton = new Button();
        videoStartButton.setGraphic(videoBeginIcon);
        videoStartButton.setBackground(Background.EMPTY);
        videoStartButton.setFocusTraversable(false);
        videoStartButton.setOnAction(e -> this.timeSlider.setValue(this.timeSlider.getLowValue()));
        this.timeSlider = new MediaSlider();
        this.timeSlider.setDurationTooltipSupplier(() -> Msg.get("ui.durationToolTip", TimeCode.fromMillis((long)(this.timeSlider.getHighValue() - this.timeSlider.getLowValue())).toShortString()));
        HBox.setHgrow((Node)this.timeSlider, (Priority)Priority.ALWAYS);
        this.timeSlider.setMinWidth(50.0);
        this.timeSlider.setMaxWidth(Double.MAX_VALUE);
        this.timeSlider.valueProperty().addListener(new ChangeListener(){
            final /* synthetic */ MediaControl this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (this.this$0.timeSlider.isValueChanging() || this.this$0.userTriggered) {
                    mp.seek(Duration.millis((double)this.this$0.timeSlider.getValue()));
                }
            }
        });
        this.timeSlider.setTooltip(new Tooltip(Msg.get("ui.videoPlayerSliderToolTip")));
        this.playTime = new Label();
        this.playTime.setPrefWidth(130.0);
        this.playTime.setMinWidth(50.0);
        this.playTime.setStyle("-fx-text-fill: white;");
        Button minVolumeButton = new Button();
        minVolumeButton.setGraphic(volumeDownIcon);
        minVolumeButton.setBackground(Background.EMPTY);
        minVolumeButton.setOnAction(e -> this.volumeSlider.setValue(0.0));
        minVolumeButton.setFocusTraversable(false);
        this.volumeSlider = new Slider();
        this.volumeSlider.setPrefWidth(70.0);
        this.volumeSlider.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.volumeSlider.setMinWidth(30.0);
        this.volumeSlider.valueProperty().addListener(ov -> mp.setVolume(this.volumeSlider.getValue() / 100.0));
        Button maxVolumeButton = new Button();
        maxVolumeButton.setGraphic(volumeUpIcon);
        maxVolumeButton.setBackground(Background.EMPTY);
        maxVolumeButton.setOnAction(e -> this.volumeSlider.setValue(100.0));
        maxVolumeButton.setFocusTraversable(false);
        Button fullscreenButton = new Button();
        fullscreenButton.setBackground(Background.EMPTY);
        fullscreenButton.setFocusTraversable(false);
        fullscreenButton.setOnAction(e -> this.videoPlayer.stage.setFullScreen(!this.videoPlayer.stage.isFullScreen()));
        fullscreenButton.setTooltip(new Tooltip(Msg.get("ui.enterExitFullScreen")));
        fullscreenButton.graphicProperty().bind((ObservableValue)Bindings.createObjectBinding((Callable)new Callable<Node>(){

            @Override
            public Node call() throws Exception {
                return MediaControl.this.videoPlayer.stage.isFullScreen() ? fullScreenExitIcon : fullScreenIcon;
            }
        }, (Observable[])new Observable[]{this.videoPlayer.stage.fullScreenProperty()}));
        this.timeSlider.lowValueProperty().addListener((ChangeListener)new ChangeListener<Number>(){
            final /* synthetic */ MediaControl this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (this.this$0.timeSlider.isLowValueChanging()) {
                    mp.seek(Duration.millis((double)this.this$0.timeSlider.getLowValue()));
                }
            }
        });
        this.timeSlider.highValueProperty().addListener((ChangeListener)new ChangeListener<Number>(){
            final /* synthetic */ MediaControl this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (this.this$0.timeSlider.isHighValueChanging()) {
                    mp.seek(Duration.millis((double)this.this$0.timeSlider.getHighValue()));
                }
            }
        });
        this.timeSlider.lowValueChangingProperty().addListener((observable, oldPressed, pressed) -> {
            if (pressed.booleanValue()) {
                mp.pause();
                mp.seek(Duration.millis((double)this.timeSlider.getLowValue()));
            } else {
                mp.seek(Duration.millis((double)this.timeSlider.getValue()));
            }
        });
        this.timeSlider.highValueChangingProperty().addListener((observable, oldPressed, pressed) -> {
            if (pressed.booleanValue()) {
                mp.pause();
                mp.seek(Duration.millis((double)this.timeSlider.getHighValue()));
            } else {
                mp.seek(Duration.millis((double)this.timeSlider.getValue()));
            }
        });
        this.mediaBar.getChildren().addAll((Object[])new Node[]{snapshotButton, new Label(" "), videoStartButton, new Label(" "), playButton, new Label("   "), this.timeSlider, new Label(" "), this.playTime, minVolumeButton, this.volumeSlider, maxVolumeButton, new Label(" "), fullscreenButton});
        this.setBottom((Node)this.mediaBar);
        this.setOnScroll(e -> {
            mp.pause();
            mp.seek(((Duration)mp.currentTimeProperty().get()).add(e.getDeltaX() < 0.0 ? Duration.millis((double)50.0) : Duration.millis((double)-50.0)));
            System.out.println(e);
        });
        this.videoPlayer.stage.setOnCloseRequest(e -> this.onHide());
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> this.cancelFader());
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> this.delayedFader.playFromStart());
        this.addEventFilter(MouseEvent.ANY, e -> {
            if (e.getEventType() != MouseEvent.MOUSE_EXITED_TARGET) {
                this.mouseEventDetected();
            }
        });
        this.delayedFader.play();
    }

    public static WritableImage toImage(Icon icon) {
        BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(null, bi.getGraphics(), 0, 0);
        return SwingFXUtils.toFXImage((BufferedImage)bi, null);
    }

    public MediaView getMediaView() {
        return this.mediaView;
    }

    protected void updateValues() {
        if (this.playTime != null && this.timeSlider != null && this.volumeSlider != null) {
            Platform.runLater(() -> {
                Duration currentTime = this.mp.getCurrentTime();
                this.playTime.setText(MediaControl.formatTime(currentTime, this.duration));
                this.timeSlider.setDisable(this.duration.isUnknown());
                if (this.mp.getCurrentTime().toMillis() >= this.timeSlider.getHighValue()) {
                    this.mp.pause();
                } else if (!(this.timeSlider.isDisabled() || !this.duration.greaterThan(Duration.ZERO) || this.timeSlider.isValueChanging() || this.timeSlider.isLowValueChanging() || this.timeSlider.isHighValueChanging())) {
                    this.userTriggered = false;
                    this.timeSlider.setValue(currentTime.toMillis());
                    this.userTriggered = true;
                }
                if (!this.volumeSlider.isValueChanging()) {
                    this.volumeSlider.setValue((double)((int)Math.round(this.mp.getVolume() * 100.0)));
                }
            });
        }
    }

    private static String formatTime(Duration elapsed, Duration duration) {
        int intElapsed = (int)Math.floor(elapsed.toSeconds());
        int elapsedHours = intElapsed / 3600;
        if (elapsedHours > 0) {
            intElapsed -= elapsedHours * 60 * 60;
        }
        int elapsedMinutes = intElapsed / 60;
        int elapsedSeconds = intElapsed - elapsedHours * 60 * 60 - elapsedMinutes * 60;
        if (duration.greaterThan(Duration.ZERO)) {
            int intDuration = (int)Math.floor(duration.toSeconds());
            int durationHours = intDuration / 3600;
            if (durationHours > 0) {
                intDuration -= durationHours * 60 * 60;
            }
            int durationMinutes = intDuration / 60;
            int durationSeconds = intDuration - durationHours * 60 * 60 - durationMinutes * 60;
            if (durationHours > 0) {
                return String.format("%d:%02d:%02d/%d:%02d:%02d", elapsedHours, elapsedMinutes, elapsedSeconds, durationHours, durationMinutes, durationSeconds);
            }
            return String.format("%02d:%02d/%02d:%02d", elapsedMinutes, elapsedSeconds, durationMinutes, durationSeconds);
        }
        if (elapsedHours > 0) {
            return String.format("%d:%02d:%02d", elapsedHours, elapsedMinutes, elapsedSeconds);
        }
        return String.format("%02d:%02d", elapsedMinutes, elapsedSeconds);
    }
}

