/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.tree.TreeNode;

class TreeNodeImpl
implements TreeNode {
    private final String name;
    private TreeNodeImpl parent;
    private Map<String, TreeNodeImpl> childMap;
    private List<TreeNodeImpl> children;

    public TreeNodeImpl(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public void addChild(TreeNodeImpl child) {
        child.parent = this;
        if (this.childMap == null) {
            this.childMap = new HashMap<String, TreeNodeImpl>();
            this.children = new ArrayList<TreeNodeImpl>();
        }
        this.childMap.put(child.name, child);
        this.children.add(child);
    }

    public TreeNodeImpl getChild(String name) {
        return this.childMap != null ? this.childMap.get(name) : null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNodeImpl other = (TreeNodeImpl)obj;
        return Objects.equals(this.name, other.name);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (this.children != null) {
            return this.children.get(childIndex);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (this.children != null) {
            int i = 0;
            for (TreeNodeImpl child : this.children) {
                if (node == child) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }
}

