/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.VirtualFolder;
import se.datadosen.jalbum.io.VirtualDirectory;
import se.datadosen.jalbum.structure.Support;
import se.datadosen.jalbum.structure.Transformer;

public class KeywordTransformer
implements Transformer<KeywordTransformer> {
    @Override
    public AlbumObject transform(AlbumObject tree, VirtualFolder newRoot) {
        Support.toStream(tree).sorted((o1, o2) -> {
            String kw1 = o1.getKeywords();
            String kw2 = o2.getKeywords();
            return kw1.compareTo(kw2);
        }).forEach(ao -> this.add((AlbumObject)ao, newRoot));
        return newRoot;
    }

    private void add(AlbumObject ao, VirtualFolder parent) {
        for (String keyword : ao.getKeywordSet()) {
            keyword = keyword.replace('/', '-');
            VirtualFolder folder = (VirtualFolder)parent.getChild(keyword = keyword.replace('\\', '-'));
            if (folder == null) {
                folder = new VirtualFolder(new VirtualDirectory(parent.getFile(), keyword), parent, parent.getFactory());
                parent.add(folder);
            }
            folder.addFileOf(ao);
        }
    }

    @Override
    public KeywordTransformer copy() {
        return new KeywordTransformer();
    }
}

