/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PlaceService;
import se.datadosen.jalbum.structure.AbstractGroupsPanel;
import se.datadosen.jalbum.structure.CountryOptions;
import se.datadosen.jalbum.structure.PlaceFormat;
import se.datadosen.jalbum.structure.PlaceOptions;
import se.datadosen.jalbum.structure.RegionOptions;
import se.datadosen.jalbum.structure.TreeNodeImpl;
import se.datadosen.util.annotations.Text;

public class JPlaceGroupsPanel
extends AbstractGroupsPanel {
    private final JPanel presetsPanel = new AbstractGroupsPanel.JRespectingPanel((LayoutManager)new MigLayout("insets 0, wrap2", "[fill][fill]"));
    private List<PlaceService.Place> samples;
    @Text(value="effects.presets")
    JLabel presetsLabel = new AbstractGroupsPanel.JRespectingLabel();
    @Text(value="preset.countryRegionPlace")
    private Action countryRegionPlacePreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JPlaceGroupsPanel.this.setOptions(CountryOptions.LONG_COUNTRY, RegionOptions.REGION, PlaceOptions.PLACE);
        }
    };
    @Text(value="preset.regionPlace")
    private Action regionPlacePreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JPlaceGroupsPanel.this.setOptions(CountryOptions.NONE, RegionOptions.REGION, PlaceOptions.PLACE);
        }
    };
    @Text(value="preset.place-region")
    private Action placeAndRegionPreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JPlaceGroupsPanel.this.setOptions(CountryOptions.NONE, RegionOptions.CUSTOM, PlaceOptions.NONE);
            JPlaceGroupsPanel.this.patterns[1].setText("ppp, rrr");
        }
    };
    @Text(value="preset.countries")
    private Action countriesPreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JPlaceGroupsPanel.this.setOptions(CountryOptions.LONG_COUNTRY, RegionOptions.NONE, PlaceOptions.NONE);
        }
    };
    @Text(value="preset.regions")
    private Action regionsPreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JPlaceGroupsPanel.this.setOptions(CountryOptions.NONE, RegionOptions.REGION, PlaceOptions.NONE);
        }
    };
    @Text(value="preset.places")
    private Action placesPreset = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JPlaceGroupsPanel.this.setOptions(CountryOptions.NONE, RegionOptions.NONE, PlaceOptions.PLACE);
        }
    };

    public JPlaceGroupsPanel(JTree samplesTree) {
        super(samplesTree, new AbstractGroupsPanel.JRespectingComboBox<CountryOptions>(CountryOptions.values()), new AbstractGroupsPanel.JRespectingComboBox<RegionOptions>(RegionOptions.values()), new AbstractGroupsPanel.JRespectingComboBox<PlaceOptions>(PlaceOptions.values()));
        this.init();
    }

    private void init() {
        Msg.setTexts(this);
        this.setLayout((LayoutManager)new MigLayout("insets 5, wrap 4", "[][][][]"));
        this.setBorder(new TitledBorder(Msg.get("ui.groups")));
        this.add((Component)this.groups[0], "span 3, growx");
        this.add(this.patterns[0]);
        this.add(Box.createHorizontalStrut(16));
        this.add((Component)this.groups[1], "growx, span 2");
        this.add(this.patterns[1]);
        this.add(Box.createHorizontalStrut(32), "span 2");
        this.add((Component)this.groups[2], "growx");
        this.add(this.patterns[2]);
        this.presetsLabel.setFont(this.presetsLabel.getFont().deriveFont(1));
        this.add((Component)this.presetsLabel, "wrap 4");
        this.presetsPanel.add(new JButton(this.placeAndRegionPreset));
        this.presetsPanel.add(new JButton(this.countriesPreset));
        this.presetsPanel.add(new JButton(this.regionPlacePreset));
        this.presetsPanel.add(new JButton(this.regionsPreset));
        this.presetsPanel.add(new JButton(this.countryRegionPlacePreset));
        this.presetsPanel.add(new JButton(this.placesPreset));
        this.add((Component)this.presetsPanel, "growx, growy, span 4");
    }

    @Override
    protected void setPresetsEnabledState() {
        this.countryRegionPlacePreset.setEnabled(this.presetsPanel.isEnabled());
        this.regionPlacePreset.setEnabled(this.presetsPanel.isEnabled());
        this.placeAndRegionPreset.setEnabled(this.presetsPanel.isEnabled());
        this.regionsPreset.setEnabled(this.presetsPanel.isEnabled());
        this.countriesPreset.setEnabled(this.presetsPanel.isEnabled());
        this.placesPreset.setEnabled(this.presetsPanel.isEnabled());
    }

    @Override
    protected TreeNodeImpl createSampleModel(List<String> patternGroups) {
        TreeNodeImpl root = new TreeNodeImpl("");
        if (this.samples == null) {
            this.samples = this.generateSamples();
        }
        for (PlaceService.Place place : this.samples) {
            TreeNodeImpl parent = root;
            for (String pattern : patternGroups) {
                if (pattern.length() <= 0) continue;
                try {
                    PlaceFormat formatter = new PlaceFormat(pattern);
                    String datePart = formatter.format(place);
                    TreeNodeImpl node = parent.getChild(datePart);
                    if (node == null) {
                        node = new TreeNodeImpl(datePart);
                        parent.addChild(node);
                    }
                    parent = node;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return root;
    }

    private List<PlaceService.Place> generateSamples() {
        ArrayList<PlaceService.Place> samples = new ArrayList<PlaceService.Place>();
        samples.add(new PlaceService.Place("Kensington", "London", "GB"));
        samples.add(new PlaceService.Place("Picadilly", "London", "GB"));
        samples.add(new PlaceService.Place("Central Park", "New York", "US"));
        samples.add(new PlaceService.Place("Bronx", "New York", "US"));
        samples.add(new PlaceService.Place("Brandenburger Tor", "Berlin", "DE"));
        return samples;
    }
}

