/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import net.jalbum.undo.UndoHandler;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.structure.JOrganizeDialog;
import se.datadosen.util.Debug;

public class JFlattenDialog
extends JOrganizeDialog {
    int processed = 0;
    protected JCheckBox deleteEmptyFolders = new JCheckBox(Msg.get("ui.deleteEmptyFolders"), true);
    private Action okAction = new AbstractAction(Msg.get("edit.processNObjects", "-----")){
        {
            this.setEnabled(false);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.putValue("Name", Msg.get("edit.processNObjects", JFlattenDialog.this.counters.getFileCount()));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tracer.getInstance().trace("Flatten");
            this.setEnabled(false);
            JFlattenDialog.this.processed = 0;
            JFlattenDialog.this.monitor = new ProgressMonitor(JFlattenDialog.this, Msg.get("ui.flattening"), null, 1, JFlattenDialog.this.counters.getFileCount());
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    UndoHandler.getInstance().undoableEditHappened(this, JFlattenDialog.this.groupEdit);
                    JFlattenDialog.this.flatten(JFlattenDialog.this.selectedObjects, JFlattenDialog.this.destinationFolder);
                    return null;
                }

                @Override
                protected void done() {
                    block3: {
                        JFlattenDialog.this.groupEdit.end();
                        UndoHandler.getInstance().update();
                        JFlattenDialog.this.window.albumExplorer.redraw();
                        try {
                            JFlattenDialog.this.logSave(JFlattenDialog.this.destinationFolder);
                            JFlattenDialog.this.organizingDone();
                            this.get();
                            JFlattenDialog.this.setVisible(false);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException ex) {
                            Throwable cause = ex.getCause();
                            if (cause instanceof OperationAbortedException) break block3;
                            Debug.showErrorDialog(JFlattenDialog.this, cause);
                        }
                    }
                    this.setEnabled(true);
                }
            };
            worker.execute();
        }
    };

    private void flatten(List<AlbumObject> objects, AlbumObject dest) throws IOException, PermissionException {
        if (objects != null) {
            for (AlbumObject ao : objects) {
                if (ao.isFolder()) {
                    if (ao.isLink() || ao.isHidden()) continue;
                    this.flatten(new ArrayList<AlbumObject>(ao.getChildren()), dest);
                    if (!this.deleteEmptyFolders.isSelected() || !ao.getChildren().isEmpty()) continue;
                    try {
                        ao.delete();
                    }
                    catch (IOException | PermissionException ex) {
                        System.err.println(ex.getMessage());
                    }
                    continue;
                }
                if (ao.getFile().getParentFile().equals(dest.getFile())) continue;
                AlbumObject existing = dest.getChild(ao.getName());
                if (existing != null && JFlattenDialog.isDuplicate(existing, ao)) {
                    System.out.println(Msg.get("edit.deletingDuplicateFile", ao));
                    ao.delete();
                } else {
                    this.move(ao, dest, dest.getUniqueName(ao.getName()), this.insertIndex++);
                }
                this.monitor.setProgress(++this.processed);
                this.monitor.setNote(ao.getParent().getName());
                if (!this.monitor.isCanceled() && this.isVisible()) continue;
                throw new OperationAbortedException();
            }
        }
    }

    public JFlattenDialog(JAlbumFrame window, List<AlbumObject> selectedObjects, AlbumObject dest, int insertIndex) {
        super(window, Msg.get("edit.flatten"), selectedObjects, dest, insertIndex);
        this.init();
    }

    @Override
    protected void init() {
        Box content = Box.createVerticalBox();
        content.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        content.add(this.deleteEmptyFolders);
        this.add(content);
        super.init();
    }

    @Override
    protected Action getOkAction() {
        return this.okAction;
    }
}

