/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import net.jalbum.undo.UndoHandler;
import se.datadosen.component.ControlPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.structure.JDateGroupsPanel;
import se.datadosen.jalbum.structure.JOrganizeDialog;
import se.datadosen.util.Debug;
import se.datadosen.util.Multilingual;
import se.datadosen.util.annotations.Text;

public class JDateGroupingDialog
extends JOrganizeDialog {
    private static List<String> patternGroups;
    protected JCheckBox deleteEmptyFolders = new JCheckBox(Msg.get("ui.deleteEmptyFolders"), true);
    @Text(value="ui.example")
    private final JLabel exampleLabel = new JLabel();
    private MultilingualTree tree = new MultilingualTree();
    private JDateGroupsPanel groupsPanel = new JDateGroupsPanel(this.tree);
    private final Action okAction = new AbstractAction(Msg.get("edit.processNObjects", "-----")){
        {
            if (patternGroups != null) {
                JDateGroupingDialog.this.groupsPanel.setPatternGroups(patternGroups);
            }
            this.setEnabled(false);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.putValue("Name", Msg.get("edit.processNObjects", JDateGroupingDialog.this.counters.getFileCount()));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tracer.getInstance().trace("Group by date");
            this.setEnabled(false);
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    UndoHandler.getInstance().undoableEditHappened(this, JDateGroupingDialog.this.groupEdit);
                    JDateGroupingDialog.this.group(JDateGroupingDialog.this.selectedObjects, JDateGroupingDialog.this.destinationFolder);
                    return null;
                }

                @Override
                protected void done() {
                    block3: {
                        JDateGroupingDialog.this.groupEdit.end();
                        UndoHandler.getInstance().update();
                        JDateGroupingDialog.this.window.albumExplorer.redraw();
                        try {
                            JDateGroupingDialog.this.logSave(JDateGroupingDialog.this.destinationFolder);
                            JDateGroupingDialog.this.organizingDone();
                            this.get();
                            JDateGroupingDialog.this.setVisible(false);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException ex) {
                            Throwable cause = ex.getCause();
                            if (cause instanceof OperationAbortedException) break block3;
                            Debug.showErrorDialog(JDateGroupingDialog.this, cause);
                        }
                    }
                    this.setEnabled(true);
                }
            };
            worker.execute();
        }
    };

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            patternGroups = this.groupsPanel.getPatternGroups();
        }
    }

    public void group(List<AlbumObject> objects, AlbumObject dest) throws IOException, PermissionException, InterruptedException {
        if (objects != null) {
            ArrayList<AlbumObject> list = new ArrayList<AlbumObject>();
            this.processed = 0;
            this.monitor = new ProgressMonitor(this, Msg.get("engine.readingMetadataInfo"), null, 1, this.counters.getFileCount());
            this.toList(objects, list, ao -> ao.getMetadata());
            list.sort((o1, o2) -> {
                long d2;
                long d1 = JDateGroupingDialog.getCameraDate(o1);
                if (d1 == (d2 = JDateGroupingDialog.getCameraDate(o2))) {
                    return 0;
                }
                return d1 > d2 ? 1 : -1;
            });
            this.processed = 0;
            this.monitor = new ProgressMonitor(this, Msg.get("ui.grouping"), null, 1, this.counters.getFileCount());
            for (AlbumObject ao2 : list) {
                this.processObject(ao2, dest);
            }
        }
    }

    private static long getCameraDate(AlbumObject ao) {
        long cameraDate = ao.getCameraDate();
        return cameraDate != 0L ? cameraDate : ao.getLastModified();
    }

    private void processObject(AlbumObject ao, AlbumObject parent) throws IOException, PermissionException {
        AlbumObject dest = parent;
        Date date = new Date(JDateGroupingDialog.getCameraDate(ao));
        for (String pattern : this.groupsPanel.getPatternGroups()) {
            if (pattern.length() <= 0) continue;
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            String datePart = formatter.format(date);
            AlbumObject folder = parent.getChild(datePart);
            if (folder == null) {
                folder = parent == dest ? parent.createFolder(this.insertIndex++, datePart) : parent.createFolder(datePart);
            }
            parent = folder;
        }
        if (!ao.getFile().getParentFile().equals(parent.getFile())) {
            AlbumObject oldParent = ao.getParent();
            AlbumObject existing = parent.getChild(ao.getName());
            if (existing != null && JDateGroupingDialog.isDuplicate(existing, ao)) {
                System.out.println(Msg.get("edit.deletingDuplicateFile", ao));
                ao.delete();
            } else {
                this.move(ao, parent, parent.getUniqueName(ao.getName()));
            }
            if (this.deleteEmptyFolders.isSelected() && oldParent.getChildren(false).isEmpty()) {
                try {
                    this.treeDeleteEmpty(oldParent, dest);
                }
                catch (IOException | PermissionException ex) {
                    System.err.println(ex.getMessage());
                }
            }
        }
        this.monitor.setProgress(++this.processed);
        this.monitor.setNote(ao.getName());
        if (this.monitor.isCanceled() || !this.isVisible()) {
            throw new OperationAbortedException();
        }
    }

    public JDateGroupingDialog(JAlbumFrame window, List<AlbumObject> selectedObjects, AlbumObject dest, int insertIndex) {
        super(window, Msg.get("edit.groupByDate"), selectedObjects, dest, insertIndex);
        this.init();
    }

    @Override
    protected void init() {
        this.groupsPanel.addPropertyChangeListener("patternGroups", evt -> this.validate());
        Msg.maintainTranslated(this);
        Box topContent = Box.createHorizontalBox();
        topContent.add(this.groupsPanel);
        ControlPanel eastPanel = new ControlPanel();
        eastPanel.add(this.exampleLabel);
        eastPanel.add("br hfill vfill", new JScrollPane(this.tree));
        topContent.add(eastPanel);
        Box content = Box.createVerticalBox();
        this.groupsPanel.setAlignmentY(0.5f);
        content.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        content.add(topContent);
        content.add(this.deleteEmptyFolders);
        this.add(content);
        super.init();
    }

    @Override
    protected Action getOkAction() {
        return this.okAction;
    }

    private class MultilingualTree
    extends JTree
    implements Multilingual {
        private MultilingualTree() {
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(130, 200);
        }

        @Override
        public void languageUpdated() {
            JDateGroupingDialog.this.groupsPanel.updateSample();
        }
    }
}

